<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ﾁｬｰﾄ情報の取得 -->
<og:query>
	select ( to_date(HIREDATE)-to_date('1970-1-1') ) * 24 * 60 * 60 as VAL1
--	select HIREDATE as VAL1
			, SAL as VAL2
	--		, EMPNO as VAL3
			, COMM  as VAL3
	from EMP
	order by 1
</og:query>

	<!-- 最大値、最小値を求めます -->
	<og:value command="SETTBL" action="ALL_MAX_MIN" />

<!--
	この形式なら、timeSetFormat を指定する必要は無い。
	<og:columnEditor column="VAL1" renderer="DATE" param="yyyy/MM/dd" />
-->

<!--
	pointStyle : "circle","triangle","rect","rectRot","cross","crossRot","star","line","dash"
-->

<og:jsChart
	chartType		= "{@chartType}"
	height			= "{@height}"
	width			= "{@width}"
	minLabelWidth	= "{@minLabelWidth}"
	labelColumn		= "VAL1"
	title			= "{@chartTitle}"
	xscaleType		= "linear"
	xmax			= "{@MAX.VAL1}"
	xmin			= "{@MIN.VAL1}"
	timeParser		= "yyyyMMddHHmmss"
	usePointStyle	= "true"
	useRenderer		= "true"
	debug			= "{@debug}"
>
	<og:jsChartData
		chartColumn		= "VAL2"
		label			= "値１"
		borderColor		= "yellow"
		backgroundColor	= "red"
		pointStyle		= "rect"
		pointRadius		= "10"
		showLine		= "true"
	/>
	<og:jsChartData
		chartColumn		= "VAL3"
		label			= "値２"
		tension			= "0"
		borderColor		= "blue"
		borderWidth		= "3"
		backgroundColor	= "green"
		pointStyle		= "circle"
		pointRadius		= "15"
		showLine		= "false"
	/>
</og:jsChart>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
