/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.model;

/**
 * 1ﾚｺｰﾄﾞのﾃﾞｰﾀを管理するｲﾝﾀｰﾌｪｰｽです。
 * Formatter で使用される単純なﾒｿｯﾄﾞを定義しています。
 *
 * @og.group 画面表示
 *
 * @version	4.0
 * @author	Kazuhiko Hasegawa
 * @since	JDK5.0,
 */
public interface DataModel<T> {

	/**
	 * 変更されたﾀｲﾌﾟ(追加)
	 *
	 * @og.rev 6.7.9.1 (2017/05/19) ｲﾝﾀｰﾌｪｰｽの見直しにより追加
	 */
	String INSERT_TYPE = "A";

	/**
	 * 変更されたﾀｲﾌﾟ(変更)
	 *
	 * @og.rev 6.7.9.1 (2017/05/19) ｲﾝﾀｰﾌｪｰｽの見直しにより追加
	 */
	String UPDATE_TYPE = "C";

	/**
	 * 変更されたﾀｲﾌﾟ(削除)
	 *
	 * @og.rev 6.7.9.1 (2017/05/19) ｲﾝﾀｰﾌｪｰｽの見直しにより追加
	 */
	String DELETE_TYPE = "D";

	/**
	 * row にあるｾﾙのｵﾌﾞｼﾞｪｸﾄ値を置き換えます。
	 *
	 * @param	vals	新しい配列値。
	 * @param	row		値が変更される行(無視されます)
	 */
	void setValues( final T[] vals,final int row ) ;

	/**
	 * ｶﾗﾑ名に対応する ｶﾗﾑ番号を返します。
	 *
	 * 特殊なｶﾗﾑが指定された場合は、負の値を返します。
	 * 例えば、[KEY.ｶﾗﾑ名]、[I]、[ROW.ID] など、特定の負の値を返します。
	 * また、ｶﾗﾑ名が元のﾃﾞｰﾀﾓﾃﾞﾙに存在しない場合も、負の値か、
	 * Exception を返します。負の値なのか、Exception なのかは、
	 * 実装に依存します。
	 *
	 * @param	columnName	値が参照されるｶﾗﾑ番号
	 *
	 * @return	指定されたｾﾙのｶﾗﾑ番号
	 */
	int getColumnNo( final String columnName ) ;

	/**
	 * ｶﾗﾑ名配列を返します。
	 * 配列ｵﾌﾞｼﾞｪｸﾄは、clone されたｺﾋﾟｰを返します。
	 *
	 * @return	ｶﾗﾑ名配列
	 */
	String[] getNames();

	/**
	 * row にあるｾﾙの属性値を配列で返します。
	 *
	 * @param	row	値が参照される行
	 *
	 * @return	指定されたｾﾙの属性値
	 */
	T[] getValues( int row ) ;

	/**
	 * row および clm にあるｾﾙの属性値を返します。
	 *
	 * @param	row	値が参照される行
	 * @param	clm	値が参照される列
	 *
	 * @return	指定されたｾﾙの値 T
	 */
	T getValue( int row, int clm ) ;

	/**
	 * clm のNativeﾀｲﾌﾟを返します。
	 * Nativeﾀｲﾌﾟはorg.opengion.fukurou.model.NativeTypeで定義されています。
	 *
	 * @og.rev 4.1.1.2 (2008/02/28) 新規追加
	 *
	 * @param	clm	値が参照される列
	 * @return	Nativeﾀｲﾌﾟ
	 * @see	org.opengion.fukurou.model.NativeType
	 */
	NativeType getNativeType( int clm );

	/**
	 * ﾃﾞｰﾀﾃｰﾌﾞﾙ内の行の数を返します。
	 *
	 * 後付I/Fのため、default 設定しておきます。
	 *
	 * @og.rev 6.7.9.1 (2017/05/19) ｲﾝﾀｰﾌｪｰｽの見直しにより追加
	 *
	 * @return	ﾓﾃﾞﾙの行数
	 */
	default int getRowCount() {
		return -1;
	}

	/**
	 * row 単位に変更されたﾀｲﾌﾟ(追加/変更/削除)を返します。
	 *
	 * 後付I/Fのため、default 設定しておきます。
	 *
	 * @og.rev 6.7.9.1 (2017/05/19) ｲﾝﾀｰﾌｪｰｽの見直しにより追加
	 *
	 * @param	row	値が参照される行
	 *
	 * @return	変更されたﾀｲﾌﾟの値 String
	 */
	default String getModifyType( final int row ) {
		return "";
	}

	/**
	 * row 単位に変更ﾀｲﾌﾟ(追加/変更/削除)をｾｯﾄします。
	 * このﾒｿｯﾄﾞでは、ﾃﾞｰﾀのﾊﾞｯｸｱｯﾌﾟは取りません。
	 * ﾀｲﾌﾟは始めに一度登録するとそれ以降に変更はかかりません。
	 * なにも変更されていない場合は、""(ｾﾞﾛｽﾄﾘﾝｸﾞ)の状態です。
	 *
	 * 後付I/Fのため、default 設定しておきます。
	 *
	 * @og.rev 6.7.9.1 (2017/05/19) ｲﾝﾀｰﾌｪｰｽの見直しにより追加
	 *
	 * @param	row		値が参照される行
	 * @param	modType	変更ﾀｲﾌﾟ(追加/変更/削除)
	 *
	 */
	default void setModifyType( final int row,final String modType ) {
		/* Document empty method body */
	}
}
