/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

// import org.opengion.hayabusa.common.HybsSystem;								// 8.0.0.0 (2021/07/31) Delete
import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.fukurou.util.StringFormat;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.TagBuffer;

/**
 * URLCALL ﾚﾝﾃﾞﾗｰは、汎用ﾎﾞﾀﾝにURLをｸﾘｯｸする機能を適用するｸﾗｽです。
 *
 * ﾎﾞﾀﾝのﾗﾍﾞﾙは、ﾗﾍﾞﾙﾘｿｰｽから取得します。それ以外に値に設定された文字列から、
 * 変数 $1,$2,$3,$4 を適用できます。
 * AAA:BBB:CCC:DDD という値を、$1,$2,$3,$4 に割り当てます。
 *
 * &lt;button name="CC" id="CC" type="button" onClick="window.open('URL','CC_FRM').close();" &gt;CC&lt;/button&gt;
 * &lt;iframe style="display:none;" name="CC_FRM"&gt;&lt;!-- --&gt;&lt;/iframe&gt;
 *
 * window.open で、すぐに閉じるのと、iframe を 見えなくすることで、ajax と同じような感じで実行できる。
 *
 * ※ 色々と試行錯誤した結果、window.open + 見えない iframe 方式で行います。
 *
 * 不採用案1：ajaxによる非同期通信
 *  &lt;button name="AA" id="AA" type="button" onClick="ajaxCall('URL');" &gt;ﾗﾍﾞﾙAA&lt;/button&gt;
 *  default.js に ajaxCall を用意して、非同期にURLを呼び出す。
 *  IE11 では、localhost 等から呼び出せない(ｾｷｭﾘﾃｨ)を低にすれば動作する。Microsoft Edge では実行可能。
 *  将来的には、こちらの方法になる可能性は大きい
 *
 * 不採用案2：location.href 遷移
 *  &lt;button name="BB" id="BB" type="button" onClick="location.href='URL'" &gt;ﾗﾍﾞﾙBB&lt;/button&gt;
 *  どうしても、URLに飛んで画面遷移してしまう。return false; を入れてもすでに遷移してしまう。
 *
 * @og.rev 7.4.2.0 (2021/05/14) 新規作成
 * @og.group ﾃﾞｰﾀ表示
 *
 * @version	7.4
 * @author	Kazuhiko Hasegawa
 * @since	JDK11,
 */
public class Renderer_URLCALL extends AbstractRenderer {
	/** このﾌﾟﾛｸﾞﾗﾑのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "8.5.2.0 (2023/07/14)" ;

//	private static final CellRenderer DB_CELL = new Renderer_URLCALL() ;

	private	String		name;
	private	String		label;
	private	String		param;

	/**
	 * ﾃﾞﾌｫﾙﾄｺﾝｽﾄﾗｸﾀｰ。
	 * このｺﾝｽﾄﾗｸﾀｰで、基本ｵﾌﾞｼﾞｪｸﾄを作成します。
	 *
	 */
	public Renderer_URLCALL() {
		super();
	}

	/**
	 * DBColumnｵﾌﾞｼﾞｪｸﾄを指定したprivateｺﾝｽﾄﾗｸﾀｰ。
	 *
	 * @param	clm	DBColumnｵﾌﾞｼﾞｪｸﾄ
	 */
	private Renderer_URLCALL( final DBColumn clm ) {
		super();

		name  = clm.getName();
		label = clm.getLabel();
		param = StringUtil.nvalAdd( clm.getRendererParam() ,
									clm.getRendererAttributes().get( "optionAttributes" ) );
	}

	/**
	 * 各ｵﾌﾞｼﾞｪｸﾄから自分のｲﾝｽﾀﾝｽを返します。
	 * 自分自身をｷｬｯｼｭするのか、新たに作成するのかは、各ｻﾌﾞｸﾗｽの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnｵﾌﾞｼﾞｪｸﾄ
	 * @return	CellRendererｵﾌﾞｼﾞｪｸﾄ
	 * @og.rtnNotNull
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return new Renderer_URLCALL( clm );
	}

	/**
	 * ﾃﾞｰﾀの表示用文字列を返します。
	 *
	 * @og.rev 7.4.2.0 (2021/05/14) 新規作成
	 *
	 * @param	value	入力値
	 * @return	ﾃﾞｰﾀの表示用文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final String value ) {
		return makeButton( name, value );
	}

	/**
	 * ﾃﾞｰﾀ出力用の文字列を作成します。
	 * ﾌｧｲﾙ等に出力する形式を想定しますので、HTMLﾀｸﾞを含まない
	 * ﾃﾞｰﾀを返します。
	 * 基本は、#getValue( String ) をそのまま返します。
	 *
	 * @og.rev 7.4.2.0 (2021/05/14) 新規作成
	 *
	 * @param	value 入力値
	 *
	 * @return	ﾃﾞｰﾀ出力用の文字列
	 * @og.rtnNotNull
	 * @see		#getValue( String )
	 */
	@Override
	public String getWriteValue( final String value ) {
		return value == null ? "" : value;
	}

	/**
	 * ﾃﾞｰﾀの表示用文字列を返します。
	 *
	 * @og.rev 7.4.2.0 (2021/05/14) 新規作成
	 * @og.rev 8.5.2.0 (2023/07/14) iframeのnameに "_FRM" 追加
	 *
	 * @param	name	ｶﾗﾑ名
	 * @param	value	入力値 表示するﾌｧｲﾙのｱﾄﾞﾚｽ
	 * @return	ﾃﾞｰﾀ表示用の文字列
	 * @og.rtnNotNull
	 */
	private String makeButton( final String name,final String value ) {
		final String newVal = new StringFormat( param, value, name ).format();	// $C は name に置き換える。

		final String button = new TagBuffer( "button" )
					.add( "name"	, name	)
					.add( "id"		, name	)
					.add( "type"	, "button"	)
					.add( "onClick"	, "window.open('" + newVal + "','" + name + "_FRM').close();" )
					.addBody( label )											// ﾎﾞﾀﾝの表示
					.makeTag();

		final String iframe = new TagBuffer( "iframe" )
//					.add( "name"	, name	)
					.add( "name"	, name + "_FRM"	)							// 8.5.2.0 (2023/07/14) Modify
					.add( "style"	, "display:none;" )
					.makeTag();

		return button + iframe;
	}
}
