/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriter;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.w3c.dom.Node;

public abstract class TIFFBaseJPEGCompressor
extends TIFFCompressor {
    private static final boolean DEBUG = false;
    protected static final String STREAM_METADATA_NAME = "javax_imageio_jpeg_stream_1.0";
    protected static final String IMAGE_METADATA_NAME = "javax_imageio_jpeg_image_1.0";
    private ImageWriteParam param = null;
    protected JPEGImageWriteParam JPEGParam = null;
    protected ImageWriter JPEGWriter = null;
    protected boolean writeAbbreviatedStream = false;
    protected IIOMetadata JPEGStreamMetadata = null;
    private IIOMetadata JPEGImageMetadata = null;
    private boolean usingCodecLib;
    private IIOByteArrayOutputStream baos;

    private static void pruneNodes(Node node, boolean bl) {
        if (node == null) {
            throw new IllegalArgumentException("tree == null!");
        }
        if (!node.getNodeName().equals(IMAGE_METADATA_NAME)) {
            throw new IllegalArgumentException("root node name is not javax_imageio_jpeg_image_1.0!");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList("JPEGvariety", "markerSequence", "sof", "componentSpec", "sos", "scanComponentSpec"));
        if (!bl) {
            arrayList.add("dht");
            arrayList.add("dhtable");
            arrayList.add("dqt");
            arrayList.add("dqtable");
        }
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node;
        List list = TIFFBaseJPEGCompressor.getAllNodes(iIOMetadataNode, null);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Node node2 = (Node)list.get(i);
            if (arrayList.contains(node2.getNodeName())) continue;
            node2.getParentNode().removeChild(node2);
        }
    }

    private static List getAllNodes(IIOMetadataNode iIOMetadataNode, List list) {
        if (list == null) {
            list = new ArrayList<Node>();
        }
        if (iIOMetadataNode.hasChildNodes()) {
            for (Node node = iIOMetadataNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                list.add(node);
                list = TIFFBaseJPEGCompressor.getAllNodes((IIOMetadataNode)node, list);
            }
        }
        return list;
    }

    public TIFFBaseJPEGCompressor(String string, int n, boolean bl, ImageWriteParam imageWriteParam) {
        super(string, n, bl);
        this.param = imageWriteParam;
    }

    protected void initJPEGWriter(boolean bl, boolean bl2) {
        Object object;
        Object object2;
        if (this.JPEGWriter != null && (bl || bl2)) {
            object2 = this.JPEGWriter.getOriginatingProvider();
            if (bl && ((object = ((ImageReaderWriterSpi)object2).getNativeStreamMetadataFormatName()) == null || !((String)object).equals(STREAM_METADATA_NAME))) {
                this.JPEGWriter = null;
            }
            if (this.JPEGWriter != null && bl2 && ((object = ((ImageReaderWriterSpi)object2).getNativeImageMetadataFormatName()) == null || !((String)object).equals(IMAGE_METADATA_NAME))) {
                this.JPEGWriter = null;
            }
        }
        if (this.JPEGWriter == null) {
            object2 = ImageIO.getImageWritersByFormatName("jpeg");
            while (object2.hasNext()) {
                object = (ImageWriter)object2.next();
                if (bl || bl2) {
                    String string;
                    ImageWriterSpi imageWriterSpi = ((ImageWriter)object).getOriginatingProvider();
                    if (bl && ((string = imageWriterSpi.getNativeStreamMetadataFormatName()) == null || !string.equals(STREAM_METADATA_NAME)) || bl2 && ((string = imageWriterSpi.getNativeImageMetadataFormatName()) == null || !string.equals(IMAGE_METADATA_NAME))) continue;
                }
                this.JPEGWriter = object;
                break;
            }
            if (this.JPEGWriter == null) {
                throw new IllegalStateException("No appropriate JPEG writers found!");
            }
        }
        this.usingCodecLib = this.JPEGWriter.getClass().getName().startsWith("com.sun.media");
        if (this.JPEGParam == null) {
            if (this.param != null && this.param instanceof JPEGImageWriteParam) {
                this.JPEGParam = (JPEGImageWriteParam)this.param;
            } else {
                this.JPEGParam = new JPEGImageWriteParam(this.writer != null ? this.writer.getLocale() : null);
                if (this.param.getCompressionMode() == 2) {
                    this.JPEGParam.setCompressionMode(2);
                    this.JPEGParam.setCompressionQuality(this.param.getCompressionQuality());
                }
            }
        }
    }

    private IIOMetadata getImageMetadata(boolean bl) throws IIOException {
        if (this.JPEGImageMetadata == null && IMAGE_METADATA_NAME.equals(this.JPEGWriter.getOriginatingProvider().getNativeImageMetadataFormatName())) {
            TIFFImageWriter tIFFImageWriter = (TIFFImageWriter)this.writer;
            this.JPEGImageMetadata = this.JPEGWriter.getDefaultImageMetadata(tIFFImageWriter.imageType, this.JPEGParam);
            Node node = this.JPEGImageMetadata.getAsTree(IMAGE_METADATA_NAME);
            try {
                TIFFBaseJPEGCompressor.pruneNodes(node, bl);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IIOException("Error pruning unwanted nodes", illegalArgumentException);
            }
            try {
                this.JPEGImageMetadata.setFromTree(IMAGE_METADATA_NAME, node);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                throw new IIOException("Cannot set pruned image metadata!", iIOInvalidTreeException);
            }
        }
        return this.JPEGImageMetadata;
    }

    public final int encode(byte[] byArray, int n, int n2, int n3, int[] nArray, int n4) throws IOException {
        int n5;
        int[] nArray2;
        Object object;
        DataBufferByte dataBufferByte;
        long l;
        ImageOutputStream imageOutputStream;
        if (this.JPEGWriter == null) {
            throw new IIOException("JPEG writer has not been initialized!");
        }
        if (!(nArray.length == 3 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8 || nArray.length == 1 && nArray[0] == 8)) {
            throw new IIOException("Can only JPEG compress 8- and 24-bit images!");
        }
        if (this.usingCodecLib && !this.writeAbbreviatedStream) {
            imageOutputStream = this.stream;
            l = this.stream.getStreamPosition();
        } else {
            if (this.baos == null) {
                this.baos = new IIOByteArrayOutputStream();
            } else {
                this.baos.reset();
            }
            imageOutputStream = new MemoryCacheImageOutputStream(this.baos);
            l = 0L;
        }
        this.JPEGWriter.setOutput(imageOutputStream);
        if (n == 0 || this.usingCodecLib) {
            dataBufferByte = new DataBufferByte(byArray, byArray.length);
        } else {
            int n6 = n4 * n3;
            object = new byte[n6];
            System.arraycopy(byArray, n, object, 0, n6);
            dataBufferByte = new DataBufferByte((byte[])object, n6);
            n = 0;
        }
        if (nArray.length == 3) {
            nArray2 = new int[]{n, n + 1, n + 2};
            object = ColorSpace.getInstance(1000);
        } else {
            nArray2 = new int[]{n};
            object = ColorSpace.getInstance(1003);
        }
        ComponentColorModel componentColorModel = new ComponentColorModel((ColorSpace)object, false, false, 1, 0);
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n2, n3, nArray.length, n4, nArray2);
        WritableRaster writableRaster = Raster.createWritableRaster(pixelInterleavedSampleModel, dataBufferByte, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        IIOMetadata iIOMetadata = this.getImageMetadata(this.writeAbbreviatedStream);
        if (this.usingCodecLib && !this.writeAbbreviatedStream) {
            this.JPEGWriter.write(null, new IIOImage(bufferedImage, null, iIOMetadata), this.JPEGParam);
            n5 = (int)(this.stream.getStreamPosition() - l);
        } else {
            if (this.writeAbbreviatedStream) {
                this.JPEGWriter.prepareWriteSequence(this.JPEGStreamMetadata);
                imageOutputStream.flush();
                this.baos.reset();
                IIOImage iIOImage = new IIOImage(bufferedImage, null, iIOMetadata);
                this.JPEGWriter.writeToSequence(iIOImage, this.JPEGParam);
                this.JPEGWriter.endWriteSequence();
            } else {
                this.JPEGWriter.write(null, new IIOImage(bufferedImage, null, iIOMetadata), this.JPEGParam);
            }
            n5 = this.baos.size();
            this.baos.writeTo(this.stream);
            this.baos.reset();
        }
        return n5;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.JPEGWriter != null) {
            this.JPEGWriter.dispose();
        }
    }

    private static class IIOByteArrayOutputStream
    extends ByteArrayOutputStream {
        IIOByteArrayOutputStream() {
        }

        IIOByteArrayOutputStream(int n) {
            super(n);
        }

        public synchronized void writeTo(ImageOutputStream imageOutputStream) throws IOException {
            imageOutputStream.write(this.buf, 0, this.count);
        }
    }
}

