/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version18;

import java.io.IOException;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Set;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.CursorFlag;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FetchType;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.OperationCloseHandle;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.version16.V16Statement;

public class V18Statement
extends V16Statement {
    private final Set<CursorFlag> cursorFlags = EnumSet.noneOf(CursorFlag.class);

    public V18Statement(FbWireDatabase database) {
        super(database);
    }

    @Override
    protected void sendExecute(int operation, RowValue parameters) throws IOException, SQLException {
        super.sendExecute(operation, parameters);
        this.getXdrOut().writeInt(this.getCursorFlagsAsInt());
    }

    @Override
    protected void fetchScrollImpl(FetchType fetchType, int fetchSize, int position) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementValid();
            if (!this.getState().isCursorOpen()) {
                throw new FbExceptionBuilder().exception(335544834).toSQLException();
            }
            try (OperationCloseHandle operationCloseHandle = this.signalFetch();){
                if (operationCloseHandle.isCancelled()) {
                    throw FbExceptionBuilder.forException(335544794).toSQLException();
                }
                try {
                    int actualFetchSize = fetchType.supportsBatch() ? fetchSize : Math.min(1, fetchSize);
                    this.sendFetchScroll(fetchType, actualFetchSize, position);
                    this.getXdrOut().flush();
                }
                catch (IOException ex) {
                    this.switchState(StatementState.ERROR);
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                try {
                    this.processFetchResponse(fetchType.direction(position));
                }
                catch (IOException ex) {
                    this.switchState(StatementState.ERROR);
                    throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                }
            }
        }
    }

    protected void sendFetchScroll(FetchType fetchType, int fetchSize, int position) throws SQLException, IOException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(112);
        xdrOut.writeInt(this.getHandle());
        xdrOut.writeBuffer(this.hasFetched() ? null : this.calculateBlr(this.getRowDescriptor()));
        xdrOut.writeInt(0);
        xdrOut.writeInt(fetchSize);
        xdrOut.writeInt(fetchType.getFbFetchType());
        xdrOut.writeInt(position);
    }

    @Override
    protected byte[] getCursorInfoImpl(byte[] requestItems, int bufferLength) throws SQLException {
        if (!this.hasFetched()) {
            throw new FbExceptionBuilder().transientException(335544834).toSQLException();
        }
        return this.getInfo(113, requestItems, bufferLength);
    }

    @Override
    public boolean supportsFetchScroll() {
        return true;
    }

    @Override
    public boolean supportsCursorInfo() {
        return true;
    }

    protected final int getCursorFlagsAsInt() {
        int flags = 0;
        for (CursorFlag flag : this.cursorFlags) {
            flags |= flag.flagValue();
        }
        return flags;
    }

    @Override
    public final void setCursorFlag(CursorFlag flag) {
        try (LockCloseable ignored = this.withLock();){
            this.cursorFlags.add(flag);
        }
    }

    @Override
    public final void clearCursorFlag(CursorFlag flag) {
        try (LockCloseable ignored = this.withLock();){
            this.cursorFlags.remove((Object)flag);
        }
    }

    @Override
    public final boolean isCursorFlagSet(CursorFlag flag) {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.cursorFlags.contains((Object)flag);
            return bl;
        }
    }
}

