/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FirebirdBlob;

public final class FBBlobOutputStream
extends OutputStream
implements FirebirdBlob.BlobOutputStream {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private FbBlob blobHandle;
    private final FBBlob owner;
    private byte[] buf;
    private int count;

    FBBlobOutputStream(FBBlob owner) throws SQLException {
        this.owner = owner;
        this.buf = new byte[owner.getBufferLength()];
        try (LockCloseable ignored = owner.withLock();){
            this.blobHandle = owner.createBlob();
            if (owner.isNew()) {
                owner.setBlobId(this.blobHandle.getBlobId());
            }
        }
    }

    @Override
    public FirebirdBlob getBlob() {
        return this.owner;
    }

    @Override
    public long length() throws IOException {
        LockCloseable ignored = this.owner.withLock();
        try {
            this.checkClosed();
            long l = this.blobHandle.length();
            if (ignored != null) {
                ignored.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.count >= this.buf.length) {
            this.flush();
        }
        this.buf[this.count++] = (byte)b;
        if (this.count == this.buf.length) {
            this.flush();
        }
    }

    private void writeSegment(byte[] buf) throws SQLException {
        try (LockCloseable ignored = this.owner.withLock();){
            this.blobHandle.putSegment(buf);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (off == 0 && len == this.buf.length || len > this.buf.length - this.count) {
            this.flush();
            this.writeInternal(b, off, len);
        } else {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
            if (this.count == this.buf.length) {
                this.flush();
            }
        }
    }

    private void writeInternal(byte[] b, int off, int len) throws IOException {
        try {
            if (off == 0 && len == b.length && len <= this.owner.getBufferLength()) {
                this.writeSegment(b);
            } else {
                int chunk = Math.min(this.owner.getBufferLength(), len);
                byte[] buffer = new byte[chunk];
                while (len > 0) {
                    if ((chunk = Math.min(len, chunk)) != buffer.length) {
                        buffer = new byte[chunk];
                    }
                    System.arraycopy(b, off, buffer, 0, chunk);
                    this.writeSegment(buffer);
                    len -= chunk;
                    off += chunk;
                }
            }
        }
        catch (SQLException ge) {
            throw new IOException("Problem writing to FBBlobOutputStream: " + ge.getMessage(), ge);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.count > 0) {
            this.writeInternal(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.blobHandle == null) {
            return;
        }
        this.flush();
        try (LockCloseable ignored = this.owner.withLock();){
            this.blobHandle.close();
            this.owner.setBlobId(this.blobHandle.getBlobId());
        }
        catch (SQLException ge) {
            throw new IOException("could not close blob: " + ge.getMessage(), ge);
        }
        finally {
            this.blobHandle = null;
            this.buf = EMPTY_BUFFER;
            this.count = 0;
        }
    }

    private void checkClosed() throws IOException {
        if (this.blobHandle == null || !this.blobHandle.isOpen()) {
            throw new IOException("Output stream is already closed.");
        }
    }
}

