/*
 * OpenI2CRADIO
 * Internal ADCONVERTER Handler
 * Copyright (C) 2013-06-20 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */
#include "adc.h"
#include "adc_int.h"
void intadc_init(void)
{
#if defined(pic18f23k22) || defined(pic18f24k22) || defined(pic18f25k22) || defined(pic18f26k22) || \
     defined(_18F23K22)  || defined(_18F24K22)  || defined(_18F25K22)  || defined(_18F26K22)

    ANSELA = AN_A_VAL;
    ANSELB = AN_B_VAL;
    ANSELC = AN_C_VAL;
#endif
#if defined(pic18f23k20) || defined(pic18f24k20) || defined(pic18f25k20) || defined(pic18f26k20) || \
      defined(_18F23K20)  || defined(_18F24K20)  || defined(_18F25K20)  || defined(_18F26K20)

    ANSEL=  _ADC_INITF;
    ANSELH = _ADCH_INITF;
#endif
#if defined(pic18f43k20) || defined(pic18f44k20) || defined(pic18f45k20) || defined(pic18f46k20) || \
    defined(_18F43K20)  || defined(_18F44K20)  || defined(_18F45K20)  || defined(_18F46K20)
    ANSEL = 0x00;
    ANSELH = 0x00;
    ANSELbits._ADC_INITF = 1;
//    ANSELH = 0x00;;
#endif
    PIR1bits.ADIF = 0;
    PIE1bits.ADIE = 0;
    IPR1bits.ADIP = 1; // High
}



unsigned int polladc(void)
{
    unsigned int a;
    if(ADCON0bits.DONE){ // converting or not enable.
        PIE1bits.ADIE = 1;
        PIR1bits.ADIF = 0;
        return 0xffff;
    } else { // Done, Clear interrupt
        a = ((ADRESH << 8)  + ADRESL) & 0x03ff;
     PIE1bits.ADIE = 0;
     PIR1bits.ADIF = 0;
     ADCON0bits.GO_DONE = 0;
     return a;
    }
}


unsigned int adc_rawtobatt(unsigned int b, unsigned int reflevel)
{
    // raw = (reflevel[0.01V] * b) / 1024 * divide :divide = 4
    return ((b >>2) * reflevel) >> 6;
}