/*
 * OpenI2CRADIO
 * Config & Main routine.
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif

#include <signal.h>

#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"
#include "menu.h"
#include "power.h"
#include "adc_int.h"

/*
 * Config words.
 */
#if defined(pic18f23k22) || defined(pic18f24k22) || defined(pic18f25k22) || defined(pic18f26k22)
//#pragma stack 0x200 256 // Set stack size to 256bytes.
#pragma config FOSC=INTIO67,BORV=190,BOREN=ON,PWRTEN=ON
#pragma config WDTEN=ON,WDTPS=32768
#pragma config PBADEN=OFF,MCLRE=EXTMCLR,STVREN=ON,LVP=OFF,DEBUG=ON,XINST=ON
//#pragma config PBADEN=OFF,MCLRE=EXTMCLR,STVREN=ON,LVP=OFF//,XINST=ON
#pragma config CP0=OFF,CP1=OFF,CPB=OFF,CPD=OFF
#pragma config WRT0=OFF,WRT1=OFF,WRTB=OFF,WRTC=OFF,WRTD=OFF
#pragma config EBTR0=OFF,EBTR1=OFF,EBTRB=OFF
#endif
// For 4xK20 or 2xK20 Series
#if defined(pic18f43k20) || defined(pic18f44k20) || defined(pic18f45k20) || defined(pic18f46k20) || \
    defined(pic18f23k20) || defined(pic18f24k20) || defined(pic18f25k20) || defined(pic18f26k20) || \
    defined(_18F43K20)  || defined(_18F44K20)  || defined(_18F45K20)  || defined(_18F46K20)  || \
    defined(_18F23K20)  || defined(_18F24K20)  || defined(_18F25K20)  || defined(_18F26K20) 

#ifdef __SDCC
#pragma stack 0x200 256
#endif

#pragma config FOSC=HS,FCMEN=ON,PWRT=ON,BOREN=NOSLP,BORV=27, \
               WDTEN=ON,WDTPS=32768,PBADEN=OFF,HFOFST=OFF,LPT1OSC=OFF, \
               MCLRE=ON,STVREN=ON,DEBUG=ON, \
               XINST=OFF
#endif
/*
 * Statuses
  */
unsigned char stereoflag;
unsigned char tuneflag;
unsigned char cnrlevel;
int diffstat;
unsigned int batlevel_6955;
unsigned int battlevel;

int recv_signal;
int backlight_counter;
unsigned char backlight_level;
unsigned char pollkeybuf[33];

//#define _LCD_DEBUG 1
#ifdef __XC
void TMR0_handler(void)
#else
SIGHANDLER(TMR0_handler)
#endif
{

   // Stop timer0
   T0CONbits.TMR0ON = 0;

   // Clear interrupt flag
   INTCONbits.TMR0IF = 0;
   INTCONbits.TMR0IE = 0;;

   return;
}
/*
 * Interrupt wake up every 1ms.
 */
#ifdef __XC
void TMR3_Handler(void)
#else
SIGHANDLER(TMR3_Handler)
#endif
{
    PIR2bits.TMR3IF  = 0;
    PIE2bits.TMR3IE  = 0;
    T3CONbits.TMR3ON = 0;
}

#ifdef __XC
void EXINT_Handler(void)
#else
SIGHANDLER(EXINT_Handler)
#endif
{
    INTCONbits.INT0IE = 0;
    INTCONbits.INT0IF = 0;
    INTCON3bits.INT1IF = 0;
    INTCON3bits.INT2IF = 0;
    INTCON3bits.INT1IE = 0;
    INTCON3bits.INT2IE = 0;

}
#ifdef __XC
void RBIF_handler(void)
#else
SIGHANDLER(RBIF_handler)
#endif
{
    power_on_inthook();
//    if(chk_powerbutton(0, 0) != 0) { // If pressed on
//      power_off(1); //
//    }
}
#ifdef __XC
void  EEPROM_handler(void)
#else
SIGHANDLER(EEPROM_handler)
#endif
{
    PIR2bits.EEIF = 0;
    EECON1bits.WREN = 0;
//    if(chk_powerbutton(0, 0) != 0) { // If pressed on
//      power_off(1); //
//    }
}

#ifdef __XC
void INADC_handler(void)
#else
SIGHANDLER(INADC_handler)
#endif
{
//    unsigned int a;
//    a = polladc();
//    if(a != 0xffff) {
//        battlevel = adc_rawtobatt(a);
//    }
    PIR1bits.ADIF = 0;
}
#ifdef __XC
void I2C_handler(void)
#else
SIGHANDLER(I2C_handler)
#endif
{
    PIR1bits.SSPIF = 0;
}
#ifdef __XC
void I2CBus_handler(void)
#else
SIGHANDLER(I2CBus_handler)
#endif
{
    PIR2bits.BCLIF = 0;
}



#ifdef __SDCC
DEF_INTLOW(intlow_handler)
  DEF_HANDLER(SIG_TMR0, TMR0_handler)
  DEF_HANDLER(SIG_INT0, EXINT_Handler)
//  DEF_HANDLER(SIG_TMR3, I2C_handler)
END_DEF

DEF_INTHIGH(inthigh_handler)
 DEF_HANDLER(SIG_RBIF, RBIF_handler)
 DEF_HANDLER(SIG_EEIF, EEPROM_handler)
 DEF_HANDLER(SIG_TMR3, TMR3_Handler)
 DEF_HANDLER(SIG_INT1, EXINT_Handler)
 DEF_HANDLER(SIG_INT2, EXINT_Handler)
 DEF_HANDLER(SIG_AD, INADC_handler)
  //DEF_HANDLER(SIG_SSP, I2C_handler)
  //DEF_HANDLER(SIG_BCOL, I2CBus_handler)
END_DEF
#else
void interrupt low_priority intlow_handler(void)
{
    if(INTCONbits.TMR0IF) TMR0_handler();
    if(INTCONbits.INT0IF) EXINT_Handler();
}

void interrupt high_priority inthigh_handler(void)
{
    if(INTCONbits.RBIF) RBIF_handler();
    if(PIR2bits.EEIF)   EEPROM_handler();
    if(PIR2bits.TMR3IF) TMR3_Handler();
    if(INTCONbits.TMR0IF) TMR0_handler();
    if(INTCON3bits.INT1IF) EXINT_Handler();
    if(INTCON3bits.INT2IF) EXINT_Handler();
    if(PIR1bits.ADIF) INADC_handler();

//    if(PIR1bits.SSPIF)    I2C_handler();
}

#ifdef __XC


#endif
#endif


void lowbatt(void)
{
//    _CLS();
//    idle_time_ms(100);
    printhelp_2lines("Low battery X)", "Press key to suspend");
    shutdown(1);
}

int main(void)
{
    unsigned char c;
    unsigned int sum = 0;
    unsigned char pbutton;
    unsigned char reset_status;
    unsigned char p;
    
    OSCCON =  (0x80 & 0b11111100) | 0b00111000;
//    OSCCON =  (0x80 & 0b11111100) | 0b00110010; // 8MHz 
    idle_init();
    keyin_init();
    keyin_ioinit();
    WDTCONbits.SWDTEN = 0; // WDT OFF.
    reset_status = chk_reset();
    idle_time_ms(300); // Wait for setup.
    switch(reset_status){
        case RESET_MCLR:
        case RESET_WDT:  // Workaround random reset.
        case RESET_BOR:
            shutdown(0); // Save and halt on BOR.
            break;
        case RESET_SOFTWARE: //
            RCONbits.RI = 0;
            break;
        default:
            break;
    }
    WDTCONbits.SWDTEN = 1; // WDT ON.
    i2c1_init();
    power_on(1);
    intadc_init();
    set_powerlamp(1);
//    idle_time_ms(125);
    valinit();

    acm1602_init(0xa0, 1); //Init LCD
//    idle_time_ms(125);
    _LOCATE(0,0);  // It's BAD-KNOWHOW, but needs AKIZUKI'S LCD :(
    _PUTCHAR(' '); //
    _LOCATE(0,1);
    printstr("Hello;-)");
    lcd_setbacklight(0xff, 255);
    idle_time_ms(1000);
    /* Check EEPROM */
    check_eeprom();
  /* Push default parameters to AKC6955*/
    setup_akc6955();
    _CLS();
    _LOCATE(0,0);
    _PUTCHAR(' ');
    battlevel = 350;
    update_status();
    update_display();
    ClrWdt();
    lcd_setbacklight(0xff, 255);
    do {
            if(battlevel <= 340) { // 3.4V
               lowbatt();
            }
        /* Main routine*/
           c = pollkeys(pollkeybuf, 5, 1); // 23*10=135ms
           p = 0;
            while(c > 0) {
                ClrWdt();
                setfreq_updown(pollkeybuf[p]);
                c--;
                 p++;
            }
//       idle_time_ms(ui_idlecount);
            _LOCATE(0,0);
            pbutton = chk_powerbutton();
            if(pbutton != 0) shutdown(1); // Button pressed.

            if(backlight_counter > 0) {
                backlight_counter--;
                lcd_setbacklight(0xff, backlight_level); // Turn ON
            } else {
                lcd_setbacklight(0x00, 0); // Turn OFF
        }
        ClrWdt();
        update_status();
        update_display();
        ClrWdt();
    } while(1);
}

