/*
 * OpenI2CRADIO
 * UI Handler(Header)
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */


#ifndef UI_H
#define	UI_H

#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#endif

#include "lcd_acm1602.h"
#include "iodef.h"

#ifdef	__cplusplus
extern "C" {
#endif


extern keyin_defs keyin_old[2];
extern keyin_defs keyin_now;
extern char keyin_fifo[32];
extern char keyin_nowp;
extern char keyin_counter;

#define _LOCATE(x,y) acm1602_locate_16x2(0xa0, x, y)
#define _PUTCHAR(c) acm1602_putchar(0xa0, c)
#define _CURSOR_LEFT() acm1602_cursordir(0xa0, 0x00)
#define _CURSOR_RIGHT() acm1602_cursordir(0xa0, 0xff)
#define _CLS() acm1602_cls(0xa0);
#define _HOME() acm1602_home(0xa0);


extern void keyin_init(void);
#ifdef __SDCC
extern void push_keyinfifo(char b) __critical;
extern char pop_keyinfifo(void) __critical;
#else
extern void push_keyinfifo(char b);
extern char pop_keyinfifo(void);
#endif
extern unsigned char readkey_compare(void);

extern void printstr(char *s);
extern void print_numeric(int i, unsigned char supressf);
extern void setsignal_tune(unsigned char flag);
extern void set_backlight(unsigned char flag, unsigned int val);
extern unsigned int read_numeric(unsigned int initial, unsigned char digit,
        char startx, char starty);
extern unsigned int subst_numeric(unsigned int start, unsigned char pos, unsigned int c);
extern void print_numeric_nosupress(unsigned int data, unsigned char digit);
extern unsigned char readkey(void);
extern unsigned char pollkeys(unsigned char *p, unsigned int limit, unsigned char repeat);
extern unsigned char pollkey_single(void);

#ifdef	__cplusplus
}
#endif

#endif	/* UI_H */

