/*
 * OpenI2CRADIO
 * Up-down UI routine.
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif
#include <signal.h>

#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"
#include "menu.h"
#include "power.h"
#include "adc_int.h"

static void setfreq_updown_amsub(void)
{
    if(amband >= AKC6955_BAND_AMEND) {
        amband = 0;
    }
    akc6955_set_amband(amband);
    amfreq = amfreq_bank[amband];
//    idle_time_62_5ms(); // 62.5ms
    ClrWdt();
    akc6955_set_freq(amfreq);
}

static void setfreq_updown_fmsub(void)
{
    if(fmband >= AKC6955_BAND_FMEND) {
        fmband = 0;
    }
    akc6955_set_fmband(fmband);
    fmfreq = fmfreq_bank[fmband];
//    idle_time_62_5ms(); // 62.5ms
    ClrWdt();
    akc6955_set_freq(fmfreq);
}

static void setband_updown(unsigned char updown)
{
    unsigned char band;
    if(fm == 0){  // MW
        band = amband + 1;
        if(amband == AKC6955_BAND_AMUSER){
            am_usrbands[am_userbandnum].freq = amfreq;
        }
        amfreq_bank[amband] = amfreq;
        if(updown == 0) { // down
            if(band <= 1) {
                band = AKC6955_BAND_AMEND - 1;
            }
            band -= 2;
        }
        amband = band;
        if(amband == AKC6955_BAND_AMUSER){
//            amfreq = am_usrbands[am_userbandnum].freq;
            call_userband(am_userbandnum);
        }
        setfreq_updown_amsub();
    } else { // FM
        if(fmband == AKC6955_BAND_FMUSER){
            fm_usrbands[fm_userbandnum].freq = fmfreq;
        }
        band = fmband + 1;
        fmfreq_bank[fmband] = fmfreq;
        if(updown == 0) { // down
            if(band <= 1) {
                band = AKC6955_BAND_FMEND - 1;
            }
            band -= 2;
        }
        fmband = band;
        if(fmband == AKC6955_BAND_FMUSER){
   //         fmfreq = fm_usrbands[fm_userbandnum].freq;
            call_userband(fm_userbandnum);
        }
        setfreq_updown_fmsub();
    }
}

void setfreq_updown(unsigned char ctlword)
{
    unsigned int freq;
    if((ctlword != charcode_e) && (ctlword >= charcode_1)
            && (ctlword <= charcode_f)) {
            backlight_counter = backlight_long;
            lcd_setbacklight(0xff, backlight_level); // Turn ON
    } else if(ctlword == charcode_e){
        if(backlight_counter != 0){
            backlight_counter = 0;
        } else {
            backlight_counter = backlight_long;
        }
        return;
    }

    update_status();
    switch(ctlword){
        case charcode_8: // Up band
            setband_updown(0xff);
            break;
        case charcode_2: // Down band
            setband_updown(0x00);
            break;
        case charcode_4: // Down Freq;
            freq = 9; // 27KHz@3K/9KStep.
            if(fm != 0) {
                freq = 10; // 250KHz
            } else if(am_mode3k == 0){
                freq = 6; // 30KHz
            }
            akc6955_down_freq(freq);
            break;
        case charcode_6: // Down Freq;
            freq = 9; // 27KHz@3K/9KStep.
            if(fm != 0) {
                freq = 10; // 250KHz
            } else if(am_mode3k == 0){
                freq = 6; // 30KHz
            }
            akc6955_up_freq(freq); // 225 or 27 or 45KHz
            break;
        case charcode_9: // Down Fast;
            freq = 33; // 99KHz@3K/9KStep.
            if(fm != 0){
                freq = 40; // 1MHz
            } else if(am_mode3k != 0){
                freq = 20; // 100KHz
            }
            akc6955_up_freq(freq); // 825 or 90 or 165KHz
            break;
        case charcode_7: // Down Fast;
            freq = 33; // 99KHz@3K/9KStep.
            if(fm != 0){
                freq = 40; // 1MHz
            } else if(am_mode3k != 0){
                freq = 20; // 100KHz
            }
            akc6955_down_freq(freq); // 825 or 90 or 165KHz
            break;
        case charcode_1: // Down Slow;
            if(fm != 0){
                freq = 4; // DOWN 100KHz
            } else {
                freq = 1; // 5KHz or 3KHz
                if(amband == AKC6955_BAND_MW2) {
                    freq = 3; // 9KHz
                } else if(amband == AKC6955_BAND_MW3) {
                    freq = 2; // 10KHz
                }
            }
            akc6955_down_freq(freq);
            break;
        case charcode_3: // Up Slow;
            if(fm != 0){
                freq = 4; // DOWN 100KHz
            } else {
                freq = 1; // 5KHz or 3KHz
                if(amband == AKC6955_BAND_MW2) {
                    freq = 3; // 9KHz
                } else if(amband == AKC6955_BAND_MW3) {
                    freq = 2; // 10KHz
                }
            }
            akc6955_up_freq(freq);
            break;
        case charcode_0: // Step
            threshold_width++;
            akc6955_set_thresh_width(threshold_width);
            akc6955_do_tune();
            break;
        case charcode_a: // Toggle FM
            toggle_amfm();
            break;
        case charcode_b:
            set_volume();
            break;
        case charcode_c:
            // Scan
            scan_start();
            break;
        case charcode_d:
            // FM Narrow/Wide
            set_stereo();
            break;
        case charcode_5:
            main_menu();
            break;
        case charcode_f:
            updown_help();
            _CLS();
            _LOCATE(0,0);
            break;
        default:
            break;
    }
//    if(fm == 0){
//        akc6955_get_amband(amband);
//        amfreq = akc6955_get_freq();
//        amfreq_bank[amband] = amfreq;
//    } else {
//        akc6955_get_fmband(fmband);
//        fmfreq = akc6955_get_freq();
//        fmfreq_bank[fmband] = fmfreq;
//    }
}
