/*
 * OpenI2CRADIO
 * Menu:HELP.
 * Copyright (C) 2013-06-21 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "menu.h"
#include "power.h"
#include "commondef.h"

const char *updown_helpstr[20] = {
        "Help", "F=exit any=continue",
        "5: Menu", " ",
        "1: Slow Down", "3: Slow Up",
        "4: Down", "6: Up",
        "7: Fast Down", "9: Fast Up",
        "2: Band Down", "8: Band Up",
        "0: Mode3K", " ",
        "a: AM/FM", "b: Volume",
        "c: Scan", "d: Stereo mode",
        "e: Backlight", "f: (Exit) Help",
    };

const char *setup_helpstr[14] = {
        "Help", "F=exit any=continue",
        "0: Power OFF", "C: Save status",
        "d: Reset default", "E: BL time",
        "A: Load", "",
        "1: FM CNR", "2: AM CNR"
        "3: FM STEREO", "4: Reserve"
        "5: Cancel", "f: (Exit) Help",
    };

const char *mainmenu_helpstr[16] = {
        "Help", "F=exit any=continue",
        "0: Setup", "1: Band",
        "3: Freq", ""
        "4: Call user", "6: Set user",
        "7: Power Off", "8: Volume",
        "9: Width", "a: AM/FM",
        "b: Cancel","c: Set user",
        "d: Input user","f: (Exit) Help",
};

const char *numeric_helpstr[10] = {
     "On numeric input", " ",
    "0-9: Numeric", "f: enter",
    "a: Delete", "b: Reset value",
    "d: Left", "e: Right",
    "Press any key", " to continue."
};


void setup_help(void)
{
    unsigned char c;
    char l;
    l = 0;
    do {
        c = printhelp_2lines(setup_helpstr[l], setup_helpstr[l + 1]);
        if(c == charcode_f) return;
        l += 2;
        if(l >= 16) {
            c = numeric_help();
            if(c == charcode_f) return;
            l = 0;
        }
    } while(1);

}

unsigned char printhelp_2lines(const char *l1, const char *l2)
{
    _CLS();
    _LOCATE(0,0);
    printstr(l1);
    _LOCATE(0,1);
    printstr(l2);
    _HOME();
    return pollkey_single();
}

unsigned char numeric_help(void)
{
    unsigned char c;
    char l;
    l = 0;
    do {
        c = printhelp_2lines(numeric_helpstr[l], numeric_helpstr[l + 1]);
        if(c == charcode_f) return charcode_f;
        l += 2;
    } while(l < 10);
    return c;
}

void mainmenu_help(void)
{
    unsigned char c;

    char l;
    l = 0;
    do {
        c = printhelp_2lines(mainmenu_helpstr[l], mainmenu_helpstr[l + 1]);
        if(c == charcode_f) return;
        l += 2;
        if(l >= 16) {
            c = numeric_help();
            if(c == charcode_f) return;
            l = 0;
        }
    } while(1);
}

void updown_help(void)
{
    unsigned char c;
    char l;

    l = 0;
    do {
        c = printhelp_2lines(updown_helpstr[l], updown_helpstr[l + 1]);
        if(c == charcode_f) return;
        l += 2;
        if(l >= 20) {
            c = numeric_help();
            if(c == charcode_f) return;
            l = 0;
        }
    } while(1);
}
