/*
 * OpenI2CRADIO
 * defines.
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else

#endif
#include <signal.h>

#include "commondef.h"
#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"
#include "menu.h"
#include "power.h"
#include "adc_int.h"
#include "backlight.h"

const banddesc ambands[19] = {
    {150,285},
    {520,1710},
    {522,1620},
    {520,1710},
    {4700, 5600},
    {3200, 4100},
    {4700, 5600},
    {5700, 6400},
    {6800, 7600},
    {9200, 10000},
    {11400,12200},
    {13500,14300},
    {15000,15900},
    {17400,17900},
    {18900,19700},
    {21400,21900},
    {11400, 17900},
    {4000,8000}, // USER
    {520,1730}
};
const banddesc fmbands[8] = {
    {8700, 10800},
    {7600, 10800},
    {7000, 9300},
    {7600, 9000},
    {6400, 8800},
    {5625, 9175},
    {17475, 22225},
    {5000, 7000} // User
};


__radioset_t setup;
unsigned char scanflag;


/*
 *
 */
void setdefault(void)
{
    char i;
    //amfreq = 954;
    //fmfreq = 8000; // 10KHz order.
    setup.amband = AKC6955_BAND_MW2;
    setup.fmband = AKC6955_BAND_FM2;
    setup.am_mode3k = 0xff;
    setup.fm = 0;
    setup.am_userbandnum = 0;
    setup.fm_userbandnum = 0;
    setup.lowboost = 0xff;
    setup.threshold_amcnr = 0;
    setup.threshold_fmcnr = 0;
    setup.threshold_fmstereo = 0;
    setup.threshold_width = 0;
    for(i = 0; i < USER_BAND_NUM; i++){
        setup.am_usrbands[i].start = 0x19;
        setup.am_usrbands[i].stop  = 0x32;
    }
    for(i = 0; i < USER_BAND_NUM; i++){
        setup.fm_usrbands[i].start = 0x19;
        setup.fm_usrbands[i].stop  = 0x32;
    }
    for(i =0; i < AKC6955_BAND_AMEND; i++){
      setup.amfreq_bank[i] = ((ambands[i].end - ambands[i].start) / 2) + ambands[i].start;
    }
    for(i =0; i <  AKC6955_BAND_FMEND ; i++){
      setup.fmfreq_bank[i] = ((fmbands[i].end - fmbands[i].start) / 2) + fmbands[i].start;
    }
    setup.memorynum = 0x00;
    for(i = 0; i < USER_MEMORY_NUM; i++) {
        setup.memoryfreqs[i].band = AKC6955_BAND_MW2;
        setup.memoryfreqs[i].fm = 0;
        setup.memoryfreqs[i].freq = 594; // NHK1 Tokyo.
    }

    setup.fmfreq = setup.fmfreq_bank[setup.fmband];
    setup.amfreq = setup.amfreq_bank[setup.amband];
    setup.stereo = 0xff; // Auto
}

void valinit(void)
{
        // UI
    setup.backlight_long = 256;
    backlight_counter = setup.backlight_long;
    setup.backlight_level = 255;
    setup.ui_idlecount = 250; // 0.25Sec
    // Statuses
    scanflag = 0;
    cnrlevel = 0;
    recv_signal = 103;
    battlevel = 0;
    batlevel_6955 = 330; // 3.30V(temporally).
    if(setup.amband > 18) setup.amband = 18;
    if(setup.fmband > 7) setup.fmband = 7;
    if(setup.am_userbandnum >= USER_BAND_NUM) setup.am_userbandnum = USER_BAND_NUM - 1;
    if(setup.fm_userbandnum >= USER_BAND_NUM) setup.fm_userbandnum = USER_BAND_NUM - 1;
    setup.volume = 36;
    setup.prevolume = 3;
    setup.fmbandwidth = 0;
//    setup.pagenum = setup.memorynum / USER_MEMORY_NUM;
    diffstat = 0;
    cnrlevel = 103;
    stereoflag = 0x00; // Auto
}
