/*
 * OpenI2CRADIO
 * Menu:HELP.
 * Copyright (C) 2013-06-21 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "menu.h"
#include "power.h"
#include "commondef.h"
#if 0
const char *userfreq_helpstr[16] = {
#else
const char *userfreq_helpstr[10] = {
#endif
       "5: Reload", " ",
        "1: -1", "7: +1",
        "4: Call direct", "6: Set",
#if 0
        "2: -28", "8: +28",
        "3: -100", "9: +100",
#endif
        "A: Exit",  "D: Reset",
        "E: Backlight", "F: (Exit) Help",
    };

const char *updown_helpstr[16] = {
        "5: Menu", "0: Narrow/Broad",
        "1: Slow Down", "3: Slow Up",
        "4: Down", "6: Up",
        "7: Fast Down", "9: Fast Up",
        "2: Band Down", "8: Band Up",
        "A: AM/FM", "B: User freq",
        "C Scan", "D: Stereo mode",
        "E: Backlight", "F: (Exit) Help",
    };

const char *setup_helpstr[14] = {
        "0: Power OFF",  "6: UI Update ",
        "3: BL Level", "E: BL time",
        "A: Load", "D: Reset default",
        "C: Save status", " ",
        "7: FM CNR", "8: AM CNR"
        "9: FM STEREO", "4: FM BW",
        "5: Cancel", "f: (Exit) Help",
    };

const char *mainmenu_helpstr[16] = {
        "0: Setup", "1: Band",
        "2:Resv" , "3: Freq",
        "4: Call user", "6: Set user",
        "7: Power Off", "8: Volume",
        "9: Reload", "A: AM/FM",
        "B: Cancel","C: Set user",
        "D: Input user","E: FM PITCH",
        " ", "F: (Exit) Help",
};

const char *numeric_helpstr[8] = {
     "On numeric", " input",
    "0-9: Numeric", "F: Enter",
    "A: Delete", "B: Reset value",
    "D: Left", "E: Right",
};


const char *version_helpstr[8] = {
    "Open I2C Radio", "V1.00",
    "(C) 2013", "Kyuma Ohta",
    "Licensed under", "GPLv2+LE",
    "Press any key", " to continue.",
};

static unsigned char help_header(void)
{
    return printhelp_2lines("Help", "F=exit any=continue");
}

static unsigned char help_version(void)
{
    unsigned char c;
    unsigned char i;
    for(i = 0; i < 8; i += 2){
        c = printhelp_2lines(version_helpstr[i], version_helpstr[i + 1]);
        if(c == charcode_f) return c;
    }
    return help_header();
}

void setup_help(void)
{
    unsigned char c;
    char l;
    l = 0;
    if(help_header() == charcode_f) return;
    do {
        c = printhelp_2lines(setup_helpstr[l], setup_helpstr[l + 1]);
        if(c == charcode_f) return;
        l += 2;
        if(l >= 14) {
            c = numeric_help();
            if(c == charcode_f) return;
            if(help_version() == charcode_f) return;
            l = 0;
        }
    } while(1);

}

unsigned char printhelp_2lines(const char *l1, const char *l2)
{
    _CLS();
    //_LOCATE(0,0);
    printstr(l1);
    _LOCATE_0_1();
    printstr(l2);
    _HOME();
    return pollkey_single();
}

unsigned char numeric_help(void)
{
    unsigned char c;
    char l;
    l = 0;
    do {
        c = printhelp_2lines(numeric_helpstr[l], numeric_helpstr[l + 1]);
        if(c == charcode_f) return charcode_f;
        l += 2;
    } while(l < 8);
    return c;
}

void mainmenu_help(void)
{
    unsigned char c;

    char l;
    l = 0;
    if(help_header() == charcode_f) return;
    do {
        c = printhelp_2lines(mainmenu_helpstr[l], mainmenu_helpstr[l + 1]);
        if(c == charcode_f) return;
        l += 2;
        if(l >= 16) {
            c = numeric_help();
            if(c == charcode_f) return;
            if(help_version() == charcode_f) return;
            l = 0;
        }
    } while(1);
}

void updown_help(void)
{
    unsigned char c;
    char l;

    l = 0;
    if(help_header() == charcode_f) return;
    do {
        c = printhelp_2lines(updown_helpstr[l], updown_helpstr[l + 1]);
        if(c == charcode_f) return;
        l += 2;
        if(l >= 16) {
            c = numeric_help();
            if(c == charcode_f) return;
            if(help_version() == charcode_f) return;
            l = 0;
        }
    } while(1);
}


void userfreq_help(void)
{
    unsigned char c;
    char l;

    l = 0;
    if(help_header() == charcode_f) return;
    do {
        c = printhelp_2lines(userfreq_helpstr[l], userfreq_helpstr[l + 1]);
        if(c == charcode_f) return;
        l += 2;
        if(l >= 10) {
            c = numeric_help();
            if(c == charcode_f) return;
            if(help_version() == charcode_f) return;
            l = 0;
        }
    } while(1);
}


