/*
 * OpenI2CRADIO
 * Menu sub-routines / USER BAND.
 * Copyright (C) 2013-09-11 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "menu.h"
#include "menu_memoryfreq.h"
#include "power.h"
#include "commondef.h"
#include "backlight.h"


void save_frequency(void)
{
   if(setup.fm != 0) {
	if(setup.fmband == AKC6955_BAND_FMUSER) {
	   setup.fm_usrbands[setup.fm_userbandnum].freq = setup.fmfreq;
	}
      setup.fmfreq_bank[setup.fmband] = setup.fmfreq;
   } else {
	if(setup.amband == AKC6955_BAND_AMUSER) {
	   setup.am_usrbands[setup.am_userbandnum].freq = setup.amfreq;
	}
      setup.amfreq_bank[setup.amband] = setup.amfreq;
   }
   
}

void call_userband(unsigned char num)
{
    unsigned int freq;
    unsigned int ch;
    unsigned char start;
    unsigned char end;
    unsigned char mode3k;
    unsigned char freq2;
    unsigned int q;
    _userband_t *p;

    if(num >= USER_BAND_NUM) return;

    if(setup.fm != 0){
       p = &(setup.fm_usrbands[num]);
    } else {
       p = &(setup.am_usrbands[num]);
    }
   
    freq = p->freq;
    start = p->start;
    end = p->stop;
    mode3k = p->mode3k;
    if(setup.fm != 0) {
       ch = ((freq - 3000) / 5) * 2;
       setup.fmband = AKC6955_BAND_FMUSER;
       setup.fm_userbandnum = num;
    } else {
       q = 5;
       if(mode3k != 0) q = 3;
       ch = freq / q;
       setup.amband = AKC6955_BAND_AMUSER;
       setup.am_userbandnum = num;
       setup.am_mode3k = mode3k;
    }
    akc6955_set_userband(start, end, ch, mode3k);
}

void set_userband(void)
{
    unsigned long from, to;
    unsigned int _from, _to;
    unsigned char c;
    unsigned char pp;
    unsigned char mode3k;
    unsigned int tmp;
    char cc;

    save_frequency();
    _CLS();
    //_LOCATE(0,0);
    printstr("User ch:");
    if(setup.fm != 0) {
	c = setup.fm_userbandnum;
    } else {
	c = setup.am_userbandnum;
    }
    c = pollkey_numeric(c);

    if(c >= USER_BAND_NUM) return;

    if(setup.fm != 0){
        from = setup.fm_usrbands[c].start * 80 + 3000; // 32*25/10
        to = setup.fm_usrbands[c].stop * 80 + 3000;
        mode3k = 0;
        _CLS();
//        _LOCATE(0,0);
        printstr("FM#");
    } else {
     mode3k = setup.am_usrbands[c].mode3k;
     pp = 96; // 3*32
     if(mode3k == 0) pp = 160; // 5*32
     from = setup.am_usrbands[c].start * pp;
     to = setup.am_usrbands[c].stop * pp;
     _CLS();
     //_LOCATE(0,0);
     printstr("AM#");
     print_numeric_nosupress(c, 1);
     printstr(" Step:");
     _LOCATE_0_1();
     printstr("0=3k 1=5k");
     cc = pollkey_single();
     if(cc == charcode_0){
	pp = 96;
	mode3k = 0xff;
     } else if(cc == charcode_1) {
	pp = 160;
	mode3k = 0;
     } else {
	goto _l0;
     }
     _CLS();
//        _LOCATE(0,0);
     printstr("AM#");
    }
   
   print_numeric_nosupress(c, 1);
   _LOCATE_0_1();
   printstr(" From:");
   from = read_numeric(from, 5, 7, 1);
   if((from & 0x80000000) != 0) goto _l0;
   _LOCATE_0_1();
   printstr(" To:  ");
   to = read_numeric(to, 5, 7, 1);
   if((to & 0x80000000) != 0) goto _l0;
   _from = (unsigned int)from;
   _to = (unsigned int)to;
   
   if(_from > _to) {
      tmp = _from;
      _from = _to;
      _to = tmp;
   }
   
   if(setup.fm != 0) {
      if(_from < 5500) _from = 5500;
      if(_to > 23000) _to = 23000;
      setup.fm_usrbands[c].start = (_from - 3000) / 80;
      setup.fm_usrbands[c].stop = (_to - 3000) / 80 + 1;
      setup.fm_usrbands[c].freq = _from;
      setup.am_usrbands[c].mode3k = 0;
      setup.fm_userbandnum = c;
   } else {
      if(_from < 100) _from = 100;
      if(_to > 22000) _to = 22000;
      setup.am_usrbands[c].start = _from / pp;
      setup.am_usrbands[c].stop = _to  / pp + 1;
      setup.am_usrbands[c].mode3k = mode3k;
      setup.am_usrbands[c].freq = _from;
      setup.am_userbandnum = c;
    }
    call_userband(c);
_l0:
    _CLS();
}

void input_userband(void)
{
    unsigned char c;
   c = printhelp_2lines("User Band", "   #");
   if((c >= charcode_a) && (c <= charcode_f)){
      _CLS();
      return;
   }
   if(c == charcode_0) {
      save_frequency();
      c = 0;
   } else {
      c = c - charcode_1 + 1;
   }
   if(c < USER_BAND_NUM) {
      if(setup.fm != 0){
	 setup.fm_userbandnum = c;
      } else {
	 setup.am_userbandnum = c;
      }
      save_frequency();
      call_userband(c);
   }
   _CLS();
}

