/*
 * OpenI2CRADIO
 * Menu sub-routines/Volume setrting.
 * Copyright (C) 2013-09-11 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "menu.h"
#include "menu_memoryfreq.h"
#include "power.h"
#include "commondef.h"
#include "backlight.h"



void set_volume(void)
{
    unsigned char c;
    unsigned char d;
    unsigned char fact;
    unsigned char dispf = 0xff;

    _CLS();
    do {
        if(dispf != 0x00){
	  _LOCATE_0_0();
            d = akc6955_getvolumemode();
            if(d == 0){
                 _PUTCHAR('D');
            } else {
                _PUTCHAR('K');
            }
            printstr(" Vol:");
            print_numeric_nosupress(setup.volume, 2);
            printstr("  F:Exit");
            _LOCATE_0_1();
            printstr("Pre:");
            _PUTCHAR('0' + (setup.prevolume & 3));
            _LOCATE(16-4, 1);
            if(setup.lowboost == 0x00){
                 printstr("   ");
            } else {
                printstr("LOW");
            }
            _HOME();
         }
     c = pollkey_single_timeout(41, 1); // 506ms
     backlight_reset(c);
     dispf = backlight_dec(dispf);
     switch(c) {
             case charcode_6:
                 setup.volume++;
                 if(setup.volume > 63) setup.volume = 63;
                 akc6955_setvolume(setup.volume);
                 break;
             case charcode_4:
                 setup.volume--;
                 if(setup.volume < 23) setup.volume = 23;
                 akc6955_setvolume(setup.volume);
                 break;
             case charcode_f:
                 _CLS();
                 return;
             case charcode_a:
                 fact = 0xff;
                 if(d != 0){
                     fact = 0x00;
                 }
                 akc6955_setvolumemode(fact);
                 akc6955_setvolume(setup.volume);
                 break;
             case charcode_b:
                 setup.prevolume++;
                 if(setup.prevolume > 3) setup.prevolume = 0;
                 akc6955_set_prevolume(setup.prevolume);
                 akc6955_setvolume(setup.volume);
                 break;
             case charcode_d:
                 fact = 0x00;
                 if(setup.lowboost == 0x00){
                     fact = 0xff;
                 }
                 setup.lowboost = fact;
                 akc6955_set_lowboost(setup.lowboost);
                 akc6955_setvolume(setup.volume);
                 break;
             default:
                 break;
         }
         if(setup.volume < 24){
             set_examp_mute(1);
        } else {
             set_examp_mute(0);
        }
        akc6955_setvolume(setup.volume);
        idle_time_ms(9); // Adjust to 1S
    } while(1);
}

