/*
 * OpenI2CRADIO
 * Up-down UI routine.
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif
#include <signal.h>

#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"
#include "menu.h"
#include "menu_memoryfreq.h"
#include "power.h"
#include "adc_int.h"
#include "backlight.h"

static void setfreq_updown_amsub(void)
{
    if(setup.amband >= AKC6955_BAND_AMEND) {
        setup.amband = 0;
    }
    akc6955_set_amband(setup.amband);
    setup.amfreq = setup.amfreq_bank[setup.amband];
//    idle_time_62_5ms(); // 62.5ms
    ClrWdt();
    akc6955_mode3k(setup.am_mode3k);
    akc6955_set_freq(setup.amfreq);
}

static void setfreq_updown_fmsub(void)
{
    if(setup.fmband >= AKC6955_BAND_FMEND) {
        setup.fmband = 0;
    }
    akc6955_set_fmband(setup.fmband);
    setup.fmfreq = setup.fmfreq_bank[setup.fmband];
//    idle_time_62_5ms(); // 62.5ms
    ClrWdt();
    akc6955_mode3k(0);
    akc6955_set_freq(setup.fmfreq);
}

static void setband_updown(unsigned char updown)
{
    unsigned char band;
    if(setup.fm == 0){  // MW
       band = setup.amband + 1;
       save_frequency();
       if(updown == 0) { // down
            if(band <= 1) {
                band = AKC6955_BAND_AMEND + 1;
            }
            band -= 2;
        }
        setup.amband = band;
        switch(setup.amband) {
	 case AKC6955_BAND_LW:
	 case AKC6955_BAND_MW2:
	   setup.am_mode3k = 0xff;
	   break;
	 case AKC6955_BAND_MW1:
	 case AKC6955_BAND_MW3:
  	 case AKC6955_BAND_MW4:
	   setup.am_mode3k = 0x00;
	   break;
	 case AKC6955_BAND_AMUSER:
           call_userband(setup.am_userbandnum);
	   break;
	 default:
	   break;
	}
        setfreq_updown_amsub();
    } else { // FM
        band = setup.fmband + 1;
        save_frequency();
        if(updown == 0) { // down
            if(band <= 1) {
                band = AKC6955_BAND_FMEND - 1;
            }
            band -= 2;
        }
        setup.fmband = band;
        if(setup.fmband == AKC6955_BAND_FMUSER){
   //         setup.fmfreq = fm_usrbands[fm_userbandnum].freq;
	   call_userband(setup.fm_userbandnum);
        }
        setfreq_updown_fmsub();
    }
}

void setfreq_updown(unsigned char ctlword)
{
    unsigned int freq;

    backlight_reset(ctlword);
    update_status();
    switch(ctlword){
        case charcode_8: // Up band
            setband_updown(0xff);
            break;
        case charcode_2: // Down band
            setband_updown(0x00);
            break;
        case charcode_6: // Up Fast;
        case charcode_4: // Down Freq;
            freq = 9; // 27KHz@3K/9KStep.
            if(setup.fm != 0) {
                freq = 10; // 250KHz
            } else if(setup.am_mode3k == 0){
                freq = 6; // 30KHz
            }
            if(ctlword == charcode_6) {
	       akc6955_up_freq(freq); // 225 or 27 or 45KHz
	    } else {
	       akc6955_down_freq(freq); // 225 or 27 or 45KHz
	    }
            break;
        case charcode_9: // Up Fast;
        case charcode_7: // Down Fast;
            freq = 33; // 99KHz@3K/9KStep.
            if(setup.fm != 0){
                freq = 40; // 1MHz
            } else if(setup.am_mode3k == 0){
                freq = 20; // 100KHz
            }
            if(ctlword == charcode_9) {
	       akc6955_up_freq(freq); // 825 or 90 or 165KHz
	    } else {
	       akc6955_down_freq(freq); // 825 or 90 or 165KHz
	    }
            break;
        case charcode_3: // Up Slow;
        case charcode_1: // Down Slow;
            if(setup.fm != 0){
	        unsigned char bw;
	        bw = akc6955_get_scanrate_fm();
                switch(bw) {
		 case 0: // 25KHz
		   freq = 1;
		   break;
		 case 1: // 50KHz
		   freq = 2;
		   break;
		 case 2:
		   freq = 4; // 100KHz
		   break;
		 default:
		   freq = 8; // 200KHz except TV1/TV2.
		   if((setup.fmband == AKC6955_BAND_TV1) || (setup.fmband == AKC6955_BAND_TV2)) { 
			freq = 4;
		   }
		   break;
		}
	       
            } else {
                freq = 1; // 5KHz or 3KHz
                if(setup.amband == AKC6955_BAND_MW2) {
                    freq = 3; // 9KHz
                } else if(setup.amband == AKC6955_BAND_MW3) {
                    freq = 2; // 10KHz
                } else if(setup.amband == AKC6955_BAND_MW4) {
                    freq = 2; // 10KHz
                }
	    }
            if(ctlword == charcode_1) {
	       akc6955_down_freq(freq);
	    } else {
	       akc6955_up_freq(freq);
	    }
       
            break;
        case charcode_0: // Step
            setup.threshold_width++;
            akc6955_set_thresh_width(setup.threshold_width);
            akc6955_do_tune();
            break;
        case charcode_a: // Toggle FM
            toggle_amfm();
            break;
        case charcode_b:
//            set_volume();
             on_updown_userfreq();
            break;
        case charcode_c:
            // Scan
            scan_start();
            break;
        case charcode_d:
            // FM Narrow/Wide
            set_stereo();
            break;
        case charcode_5:
            main_menu();
            break;
        case charcode_f:
            updown_help();
            _CLS();
            //_LOCATE(0,0);
            break;
        default:
            break;
    }
}
