/*
 * Decompiled with CFR 0.152.
 */
package net.black_cow.opennip.ui.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.black_cow.opennip.opennipcore.NipManager;
import net.black_cow.opennip.opennipcore.NipPlayer;
import net.black_cow.opennip.opennipcore.NipStone;
import net.black_cow.opennip.strategy.MouseClickStrategy;
import net.black_cow.opennip.ui.swing.BoardLabel;
import net.black_cow.opennip.ui.swing.ConcreteNipObserver;
import net.black_cow.opennip.ui.swing.MessageDialog;
import net.black_cow.opennip.ui.swing.MessageModalDialog;
import net.black_cow.opennip.ui.swing.MouseClickInfo;
import net.black_cow.opennip.ui.swing.UIConstant;

public class OpenNipUI {
    private MouseClickInfo info = new MouseClickInfo();
    private static NipManager manager;
    private JFrame frame = new JFrame("OpenNip");
    private JPanel boardPanel = new JPanel();
    private BoardLabel board;
    private JPanel informationPanel = new JPanel();
    private JLabel information = new JLabel();
    private JPanel messagePanel = new JPanel();
    private JLabel message = new JLabel();
    private int whiteScore;
    private int blackScore;
    private MessageDialog dialog = new MessageDialog(this.frame);
    private MessageModalDialog modalDialog = new MessageModalDialog(this.frame);

    public static void main(String[] args) {
        OpenNipUI ui = new OpenNipUI();
        ui.initGUI();
        NipPlayer first = new NipPlayer();
        NipPlayer second = new NipPlayer();
        first.setStrategy(new MouseClickStrategy(ui.info));
        second.setStrategy(new MouseClickStrategy(ui.info));
        ui.initDialogs();
        ui.showDialog("OpenNip", 1500L, UIConstant.TITLE_MESSAGE_FONT, UIConstant.TITLE_MESSAGE_COLOR);
        do {
            manager = new NipManager(first, second);
            manager.addObservers(new ConcreteNipObserver(ui));
            manager.play();
        } while (ui.showModalDialog("\u3082\u3046\u4e00\u5ea6\u904a\u3073\u307e\u3059\u304b\uff1f", UIConstant.DESCRIPTION_FONT, null));
    }

    public OpenNipUI() {
        this.board = new BoardLabel(new ImageIcon(this.getClass().getClassLoader().getResource("Board.gif")), this.info);
    }

    void setMessage(String message) {
        this.message.setText(message);
    }

    void refreshInformation() {
        this.information.setText("White " + this.whiteScore + " " + "-" + " " + this.blackScore + " " + "Black");
    }

    void refresh() {
        this.board.refresh(manager);
        this.whiteScore = manager.getStoneCount(NipStone.Color.WHITE);
        this.blackScore = manager.getStoneCount(NipStone.Color.BLACK);
        this.refreshInformation();
    }

    void drawBoard(int row, int column, NipStone.Color color) {
        this.board.paint(row, column, color);
    }

    void incrementScore(NipStone.Color color) {
        if (color.equals((Object)NipStone.Color.BLACK)) {
            ++this.blackScore;
        } else {
            ++this.whiteScore;
        }
    }

    void decrementScore(NipStone.Color color) {
        if (color.equals((Object)NipStone.Color.BLACK)) {
            --this.blackScore;
        } else {
            --this.whiteScore;
        }
    }

    private void initGUI() {
        this.setBoardPanel();
        this.setInformationPanel();
        this.setMessagePanel();
        this.setFrameFactors();
    }

    private void setBoardPanel() {
        this.boardPanel.setBackground(UIConstant.BOARD_PANEL_COLOR);
        this.boardPanel.add(this.board);
        this.boardPanel.setPreferredSize(UIConstant.BOARD_PANEL_SIZE);
    }

    private void setInformationPanel() {
        this.information.setText("White 0 - 0 Black");
        this.informationPanel.setBackground(UIConstant.INFORMATION_PANEL_COLOR);
        this.information.setFont(UIConstant.INFORMATION_FONT);
        this.information.setHorizontalAlignment(0);
        this.information.setVerticalAlignment(0);
        this.information.setPreferredSize(UIConstant.INFORMATION_PANEL_SIZE);
        this.informationPanel.setLayout(new GridLayout(1, 1));
        this.informationPanel.setPreferredSize(UIConstant.INFORMATION_PANEL_SIZE);
        this.informationPanel.add(this.information);
    }

    private void setMessagePanel() {
        this.messagePanel.setBackground(UIConstant.MESSAGE_PANEL_COLOR);
        this.message.setFont(UIConstant.MESSAGE_FONT);
        this.message.setHorizontalAlignment(0);
        this.message.setVerticalAlignment(0);
        this.message.setPreferredSize(UIConstant.MESSAGE_PANEL_SIZE);
        this.messagePanel.setLayout(new GridLayout(1, 1));
        this.messagePanel.add(this.message);
        this.messagePanel.setPreferredSize(UIConstant.MESSAGE_PANEL_SIZE);
    }

    private void setFrameFactors() {
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        this.frame.getContentPane().add(this.boardPanel);
        this.frame.getContentPane().add(this.informationPanel);
        this.frame.getContentPane().add(this.messagePanel);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    private void initDialogs() {
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.frame);
        this.modalDialog.setResizable(false);
        this.modalDialog.setLocationRelativeTo(this.frame);
    }

    void showDialog(String message, long lifeTime, Font font, Color textColor) {
        this.dialog.setText(message, font, textColor);
        this.dialog.setVisible(true);
        try {
            Thread.sleep(lifeTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.dialog.setVisible(false);
    }

    boolean showModalDialog(String message, Font font, Color textColor) {
        this.modalDialog.setText(message, font, textColor);
        this.modalDialog.setVisible(true);
        return this.modalDialog.isReplay();
    }
}

