/** OOo *************************************************************
                      OpenOffice.org Japanese Native-Language Project
                                 Japanese Configuration Program (JCP)

OpenOffice.org ̃NCbNNAOpenOffice.org ̊e\tg(Calc, Draw,
Impress, Writer Ȃ)NĂ邩ǂ`FbNvO

           Programmed by CY / Ken-taro NANAUMI in Mar.15.2003
*********************************************************************/

/* ------------------------------------------------------------------ O */
#include <windows.h>
#include <tlhelp32.h>
#include <vdmdbg.h>
#include <psapi.h>
#include "Resdialog.h"
#define MAX_PATH_LENGTH 1000

typedef BOOL (CALLBACK *PROCENUMPROC) (DWORD, WORD, LPSTR, LPARAM);
typedef struct
{
  DWORD          dwPID ;
  PROCENUMPROC   lpProc ;
  DWORD          lParam ;
  BOOL           bEnd ;
} EnumInfoStruct ;

/* ---------------------------------------------------- ֐vg^Cv錾 */
BOOL WINAPI checkOOoRunning(void);
BOOL checkProcess(LPCSTR lpszFullPath);
char *getFileName(char *lpszPath);
char *getPathFolder(char *lpszPath);
LRESULT CALLBACK DlgProc(HWND hDlgWnd, UINT msg, WPARAM wp, LPARAM lp);
void setWindowCenter(HWND hWnd);

/* -------------------------------------------------------------- 萔̒` */
BOOL isOOoRunning = false;
char *lpszOOoProcess = "soffice.exe";
char *lpszSetupProgram = "_.exe";

/* -------------------------------------------------------------- ֐̒` */

/* C[`
 */
int WINAPI WinMain( HINSTANCE hInstance , HINSTANCE hPrevInstance , LPSTR  lpCmdLine , int  nCmdShow )
{
  // OOo NCbNNĂ邩`FbN
  checkOOoRunning();

  // Ԃ̕\
  if( isOOoRunning) {
    // Ăꍇ
    // NCbNNOOõ\tg̏I𑣂_CAO{bNX\
    DialogBox(hInstance, "IDD_DIALOG", NULL, (DLGPROC)DlgProc);
  } else {
    // ĂȂꍇ
    // {œvO̖{̂𓮂
    char Path[MAX_PATH_LENGTH + 1]; // st@Ci[obt@
    GetModuleFileName(NULL, Path, MAX_PATH_LENGTH);
    HINSTANCE result = ShellExecute(NULL, "open", strcat(getPathFolder(Path), lpszSetupProgram), NULL, NULL, SW_SHOW);

    // `FbN
    if((int)result <= 32) {
      MessageBox(NULL,
                 (LPCSTR)"炩̗RŃZbgAbvJnł܂łB\n\n{œvO_E[h̍ۂɉꂽ\̂ŁA\nēx_E[hē蒼Ă܂悤肢܂B",
                 (LPCSTR)"OpenOffice.org {œvO",
                 MB_OK | MB_ICONEXCLAMATION);
    }
  }
  return 0;
}


/*pXt@C擾
 *
 * F  lpszPath    pXւ̃|C^
 *
 * ԂlFt@Cւ̃|C^
 *         pXɃt@C܂܂Ȃꍇ̓k""ւ̃|C^
 *         pX̋؂ \ ܂ / ܂ : Ȃꍇ͈̂܂ܕԂ
 */
char *getFileName(char *lpszPath)
{
  char *lpszFileName = lpszPath;
  char *lpszCurrentChar = lpszPath;

  while(*lpszCurrentChar != '\0')
    {
      /* 2oCgȂ΃pX̋؂ł͂Ȃ̂Ń`FbNȂ */
      if( IsDBCSLeadByte(*lpszCurrentChar) == 0)
        {
          /* pX̋؂ \ ܂ / ܂ : A̎̕w|C^ۑ */
          if( (*lpszCurrentChar == '\\') || (*lpszCurrentChar == '/') || (*lpszCurrentChar == ':'))
            {
              lpszFileName = lpszCurrentChar + 1;
            }
        }
      lpszCurrentChar = CharNext(lpszCurrentChar);
    }
  return lpszFileName;
}


/*pXt@C؂̂Ă
 *
 * F  lpszPath    pXւ̃|C^
 * ԂlFpXւ̃|C^iƓAhXj
 */
char *getPathFolder(char *lpszPath)
{
  char *lpszFileName = lpszPath;
  char *lpszCurrentChar = lpszPath;

  while(*lpszCurrentChar != '\0')
    {
      /* 2oCgȂ΃pX̋؂ł͂Ȃ̂Ń`FbNȂ */
      if( IsDBCSLeadByte(*lpszCurrentChar) == 0)
        {
          /* pX̋؂ \ ܂ / ܂ : A̎̕w|C^ۑ */
          if( (*lpszCurrentChar == '\\') || (*lpszCurrentChar == '/') || (*lpszCurrentChar == ':'))
            {
              lpszFileName = lpszCurrentChar + 1;
            }
        }
      lpszCurrentChar = CharNext(lpszCurrentChar);
    }
  *lpszFileName = '\0';
  *(lpszFileName+1) = '\0';
  return lpszPath;
}


/*NCbNNOOõ\tg̏I𑣂_CAO{bNX̃vV[W
 */
LRESULT CALLBACK DlgProc(HWND hDlgWnd, UINT msg, WPARAM wp, LPARAM lp)
{
  switch (msg) {
  case WM_INITDIALOG:
    setWindowCenter(hDlgWnd);
    return false;

  case WM_COMMAND:
    switch (LOWORD(wp)) {
    case IDC_BUTTON105:
      EndDialog(hDlgWnd, IDC_BUTTON105);
      break;
    default:
      return false;
    }

  case WM_CLOSE:
    EndDialog(hDlgWnd, IDC_BUTTON105);
    break;

  default:
    return false;
  }
  return true;
}


/*EBhEʂ̒ɔzu
 *
 * F  hWnd    ɔzuEBhEnh
 */
void setWindowCenter(HWND hWnd)
{
  HWND hDeskWnd;
  RECT deskrc, rc;
  int x, y;

  hDeskWnd = GetDesktopWindow();
  GetWindowRect(hDeskWnd, (LPRECT)&deskrc);
  GetWindowRect(hWnd, (LPRECT)&rc);
  x = (deskrc.right - (rc.right-rc.left)) / 2;
  y = (deskrc.bottom - (rc.bottom-rc.top)) / 2;
  SetWindowPos(hWnd, HWND_TOP, x, y, (rc.right-rc.left), (rc.bottom-rc.top),SWP_SHOWWINDOW);
}


/* vZX OOo ܂̓NCbNNǂ`FbN
 *
 * F  procFullPath    vZX̃tpX
 * ԂlFɐ^Ԃ
 */
BOOL checkProcess(LPCSTR lpszFullPath)
{
  if( lstrcmpi(getFileName((char *)lpszFullPath), lpszOOoProcess) == 0) {
    isOOoRunning = true;
  }
  return true;
}


/* OOo ܂̓NCbNNĂ邩`FbN
 *   Ă΃O[oϐ isOOoRunning ɐ^
 *
 * ԂlF  `FbNłΐ^AG[Ȃǂɂ`FbNłȂ΋U
 */
BOOL WINAPI checkOOoRunning (void)
{
  OSVERSIONINFO  osver;
  HINSTANCE      hInstLib;
  HINSTANCE      hInstLib2;
  HANDLE         hSnapShot;
  PROCESSENTRY32 procentry;
  BOOL           bFlag;
  LPDWORD        lpdwPIDs;
  DWORD          dwSize, dwSize2, dwIndex;
  HMODULE        hMod;
  HANDLE         hProcess;
  char           szFileName [MAX_PATH];
  EnumInfoStruct sInfo;

  // ToolHelp ֐̃|C^
  HANDLE (WINAPI *lpfCreateToolhelp32Snapshot) (DWORD,DWORD);
  BOOL (WINAPI *lpfProcess32First) (HANDLE,LPPROCESSENTRY32);
  BOOL (WINAPI *lpfProcess32Next) (HANDLE,LPPROCESSENTRY32);

  // PSAPI ֐̃|C^
  BOOL (WINAPI *lpfEnumProcesses) (DWORD *, DWORD cb, DWORD *);
  BOOL (WINAPI *lpfEnumProcessModules) (HANDLE, HMODULE *,
                                        DWORD, LPDWORD);
  DWORD (WINAPI *lpfGetModuleFileNameEx) (HANDLE, HMODULE,
                                          LPTSTR, DWORD);

  // VDMDBG ֐̃|C^
  INT (WINAPI *lpfVDMEnumTaskWOWEx) (DWORD,
                                     TASKENUMPROCEX  fp, LPARAM);


  // s Windows 95 n Windows NT nmF
  osver.dwOSVersionInfoSize = sizeof (osver);
  if (!GetVersionEx (&osver))
    {
      return false;
    }

  // Windows NT n̏ꍇ
  if (osver.dwPlatformId == VER_PLATFORM_WIN32_NT)
    {
      // Windows NT 4.0 ܂͂Âo[WȂ΃`FbNȂ
      if (osver.dwMajorVersion <= 4) {
        return false;
      }
      hInstLib = LoadLibraryA ("PSAPI.DLL");
      if (hInstLib == NULL) {
        return false;
      }
      hInstLib2 = LoadLibraryA ("VDMDBG.DLL");
      if (hInstLib2 == NULL) {
        return false;
      }
      lpfEnumProcesses = (BOOL (WINAPI *) (DWORD *,DWORD,DWORD*) )
        GetProcAddress (hInstLib, "EnumProcesses");
      lpfEnumProcessModules = (BOOL(WINAPI *) (HANDLE, HMODULE *,
                                               DWORD, LPDWORD) ) GetProcAddress (hInstLib,
                                                                                 "EnumProcessModules");
      lpfGetModuleFileNameEx = (DWORD (WINAPI *) (HANDLE, HMODULE,
                                                  LPTSTR, DWORD) ) GetProcAddress (hInstLib,
                                                                                   "GetModuleFileNameExA");
      lpfVDMEnumTaskWOWEx = (INT (WINAPI *) (DWORD, TASKENUMPROCEX,
                                             LPARAM) ) GetProcAddress (hInstLib2, "VDMEnumTaskWOWEx");

      // vV[W̃AhX擾łȂ΋N`FbN֐𔲂
      if (lpfEnumProcesses == NULL ||
          lpfEnumProcessModules == NULL ||
          lpfGetModuleFileNameEx == NULL ||
          lpfVDMEnumTaskWOWEx == NULL)
        {
          FreeLibrary (hInstLib) ;
          FreeLibrary (hInstLib2) ;
          return false;
        }

      // ݃VXeɂ邷ׂĂ ProcID 擾
      dwSize2 = 256 * sizeof (DWORD);
      lpdwPIDs = NULL;
      do
        {
          if (lpdwPIDs)
            {
              HeapFree (GetProcessHeap(), 0, lpdwPIDs);
              dwSize2 *= 2;
            }
          lpdwPIDs = (unsigned long *)HeapAlloc (GetProcessHeap(), 0, dwSize2);
          if (lpdwPIDs == NULL) // mۂɎsN`FbN֐𔲂
            {
              FreeLibrary (hInstLib);
              FreeLibrary (hInstLib2);
              return false;
            }
          if (!lpfEnumProcesses (lpdwPIDs, dwSize2, &dwSize) )
            {  // ֐ĂяoɎsN`FbN֐𔲂
              HeapFree (GetProcessHeap(), 0, lpdwPIDs);
              FreeLibrary (hInstLib);
              FreeLibrary (hInstLib2);
              return false;
            }
        } while (dwSize == dwSize2);

      // 擾 ProcID ̐Zo
      dwSize /= sizeof (DWORD) ;

      // SvZXɑ΂āAvZX̃`FbNiN`FbNj
      for (dwIndex = 0 ; dwIndex < dwSize ; dwIndex++)
        {
          szFileName [0] = 0 ;
          // vZXI[v
          hProcess = OpenProcess (
            PROCESS_QUERY_INFORMATION | PROCESS_VM_READ,
            FALSE, lpdwPIDs [dwIndex] ) ;
          if (hProcess != NULL)
            {
              // vZX̍ŏ̃W[݂̂擾
              if (lpfEnumProcessModules (hProcess, &hMod, sizeof (hMod), &dwSize2))
                {
                  // vZX̃tpX擾
                  if (!lpfGetModuleFileNameEx (hProcess, hMod,
                                               szFileName, sizeof (szFileName) ) )
                    {
                      szFileName [0] = 0 ;
                    }
                }
              CloseHandle (hProcess) ;
            }
          // vZX̃tpXɂN`FbN
          checkProcess(szFileName);
        }
      HeapFree (GetProcessHeap(), 0, lpdwPIDs) ;
      FreeLibrary (hInstLib2) ;

      // Windows 95 n̏ꍇ
    } else if (osver.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
      {
        hInstLib = LoadLibraryA ("Kernel32.DLL");
        if (hInstLib == NULL) {
          return false;
        }
        // vV[W̃AhX擾
        lpfCreateToolhelp32Snapshot=
          (HANDLE (WINAPI *) (DWORD,DWORD) )
            GetProcAddress (hInstLib,
                            "CreateToolhelp32Snapshot") ;
        lpfProcess32First=
          (BOOL (WINAPI *) (HANDLE,LPPROCESSENTRY32) )
            GetProcAddress (hInstLib, "Process32First") ;
        lpfProcess32Next=
          (BOOL (WINAPI *) (HANDLE,LPPROCESSENTRY32) )
            GetProcAddress (hInstLib, "Process32Next") ;

        // vV[W̃AhX擾łȂ΋N`FbN֐𔲂
        if (lpfProcess32Next == NULL ||
            lpfProcess32First == NULL ||
            lpfCreateToolhelp32Snapshot == NULL)
          {
            FreeLibrary (hInstLib);
            return false;
          }

        // VXe vZX Toolhelp XibvVbgnh擾
        hSnapShot = lpfCreateToolhelp32Snapshot (
          TH32CS_SNAPPROCESS, 0);

        // sȒlԂĂN`FbN֐𔲂
        if (hSnapShot == INVALID_HANDLE_VALUE)
          {
            FreeLibrary (hInstLib);
            return false;
          }

        // ŏ̃vZX̏擾
        procentry.dwSize = sizeof (PROCESSENTRY32);
        bFlag = lpfProcess32First (hSnapShot, &procentry);

        // vZXԌJԂ
        while (bFlag)
          {
            // vZX̃tpXɂN`FbN
            checkProcess(procentry.szExeFile);

            // `FbNΏۂ̃vZX
            procentry.dwSize = sizeof (PROCESSENTRY32);
            bFlag = lpfProcess32Next (hSnapShot, &procentry);
          }
      } else {
        // Windows ̃o[Wsȏꍇ
        return false;
      }
  // Cu
  FreeLibrary (hInstLib);

  return true;
}

