/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.common
 *  t@CFCommonSettings.java
 *  FAvP[V̋ʐݒ킷NXłB
 *
 *  쐬: 2004/01/12
 */
package openolap.viewer.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

import openolap.viewer.MeasureMemberType;

/**
 *  NXFCommonSettings<br>
 *  FAvP[V̋ʐݒ킷NXłB
 */
public class CommonSettings implements Serializable {

	// ********** CX^Xϐ **********

	/** g̃IuWFNg */
	static final CommonSettings commonSettings = new CommonSettings(CommonUtils.FLGTobool(Messages.getString("InitializeStatus.valueXmlContainsAxesInfoFLG")));

	/** W[o[^CvIuWFNg̃Xg */
	final private ArrayList<MeasureMemberType> measureMemberTypeList = new ArrayList<MeasureMemberType>();

	/** lXMLɎiIDуo[L[̑gݍ킹j܂߂邩 */
	final private boolean valueXmlContainsAxesInfo;
	
	// ********** RXgN^ **********

	/**
	 * AvP[V̋ʐݒ킷IuWFNg𐶐܂B
	 * IuWFNg͈̂ݐ邱ƂKvB
	 */
	private CommonSettings (boolean valueXmlContainsAxesInfo) {
		this.valueXmlContainsAxesInfo = valueXmlContainsAxesInfo;
	}

	// ********** static\bh **********

	/**
	 * AvP[V̋ʐݒ킷IuWFNg擾܂B
	 * @return ̃NX̃IuWFNg
	 */
	public static CommonSettings getCommonSettings() {
		return commonSettings;
	}

	// ********** \bh **********

	/**
	 * W[o[^CvIuWFNgZbgB
	 * @param measureMemberType W[o[^CvIuWFNg
	 */
	public void addMeasureMemberTypeList(MeasureMemberType measureMemberType) {
		this.measureMemberTypeList.add(measureMemberType);
	}

	/**
	 * W[o[^CvIuWFNg̃XgZbgB
	 * @param measureMemberTypeList W[o[^CvIuWFNg̃Xg
	 */
	public void addMeasureMemberTypeList(ArrayList<MeasureMemberType> measureMemberTypeList) {
		if(measureMemberTypeList == null) { throw new IllegalArgumentException(); }

		Iterator it = measureMemberTypeList.iterator();
		while (it.hasNext()) {
			MeasureMemberType measureMemberType = null;
			Object obj = (Object) it.next();
			if (obj instanceof MeasureMemberType) {
				measureMemberType = (MeasureMemberType) obj;
			} else {
				throw new IllegalArgumentException();
			}
			this.measureMemberTypeList.add(measureMemberType);
		}
	}

	/**
	 * ^W[o^CvID胁W[o^CvIuWFNg߂B
	 * @param typeId W[o^CvID
	 * @return W[o^CvIuWFNg
	 */
	public MeasureMemberType getMeasureMemberTypeByID(String typeId) {
		Iterator<MeasureMemberType> it = this.measureMemberTypeList.iterator();
		while (it.hasNext()){
			MeasureMemberType measureMemberType = it.next();
			if(typeId.equals(measureMemberType.getId())) {
				return measureMemberType;
			}
		}
		return null;
	}

	/**
	 * W[o^CvIuWFNgXg̐擪̃IuWFNg߂B
	 * @return W[o^CvIuWFNg
	 */
	public MeasureMemberType getFirstMeasureMemberType() {
		return (MeasureMemberType)measureMemberTypeList.get(0);
	}

	// ********** Getter \bh **********

	/**
	 * W[o^CvIuWFNgXg߂B
	 * @return W[o^CvIuWFNg̃Xg
	 */
	public ArrayList<MeasureMemberType> getMeasureMemberTypeList() {
		return measureMemberTypeList;
	}

	/**
	 * lXMLɎ܂߂ꍇtrueA܂߂Ȃꍇfalse߂B
	 * iFIDуo[L[̑gݍ킹j
	 * @return lXMLɎj܂߂邩
	 */
	public boolean getValueXmlContainsAxesInfo() {
		return valueXmlContainsAxesInfo;
	}


}
