/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFRequestHelper.java
 *  FNCAg̃NGXgƏRtNXłB
 *
 *  쐬: 2004/01/05
 */

package openolap.viewer.controller;

import java.io.IOException;
import java.net.URLDecoder;

import javax.servlet.ServletException;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import openolap.viewer.XMLConverter;
import openolap.viewer.chart.ChartCreator;
import openolap.viewer.common.CommonSettings;

/**
 *  NXFGetChartFromXMLCommand<br>
 *  FNCAg著MĂJFreeChartpXMLhLgOt𐶐NXłB
 *        <KvRequestp[^>
 * 	      strCode:       ChartpXMLhLg̕R[h
 *        chartXML:      ChartpXMLhLg
 *        chartDispMode: `[g\[h 
 *                         l = xml   F XML o͂AC[Wt@C\pJSPĂяo[h
 *                         l = image F C[Wt@C𒼐ڏo͂郂[h
 */
public class GetChartFromXMLCommand implements Command {

	final private String outXMLMode   = "xml";		// XML o͂AC[Wt@C\pJSPĂяo[h
	final private String outImageMode = "image";		// C[Wt@C𒼐ڏo͂郂[h
	final private String outJSPPage   = "/spread/chartInfo.jsp";	// C[Wt@C\pJSP

	// ********** \bh **********

	/*
	 * JFreeChart\B
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return dispatchJSP/HTML̃pX
	 *         XMLvaluelł͂ȂȂǂ̗RŁANumberFormatExceptionꍇ́A
	 *         uNy[W߂
	 */
	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException, Exception {

			// ChartpXMLhLg̕R[h擾
			String sourceStrCode = helper.getRequest().getParameter("strCode");

			// ChartpXMLhLg𐶐A擾
			String tmpChartXML = helper.getRequest().getParameter("chartXML");
//			String chartXML = new String(tmpChartXML.getBytes(sourceStrCode), "Shift_JIS");
			String chartXML = URLDecoder.decode(tmpChartXML , "UTF-8");

			XMLConverter xmlConverter = new XMLConverter();
			Document chartXMLDoc = xmlConverter.toXMLDocument(chartXML);

			// XMLValuevfAtH[}bgiJ}i,jApʉ݋Li\jASpʉ݋LijAi%jj폜
			NodeList values =  xmlConverter.selectNodes(chartXMLDoc, "//Value");
			for (int i=0; i<values.getLength(); i++) {
				Node node = values.item(i);
				String value = node.getFirstChild().getNodeValue();
				String numberValue = value.replaceAll(",", "");
				numberValue = numberValue.replaceAll("\\\\", "");
				numberValue = numberValue.replaceAll("", "");
				numberValue = numberValue.replaceAll("%", "");
				node.getFirstChild().setNodeValue(numberValue);	
			}


			// ChartCreatorgpAXMLhLg`[gݒ
			ChartCreator chartCreator = new ChartCreator();
			try {
				chartCreator.createChart(chartXMLDoc);
			} catch (NumberFormatException e) {
				// XMLValuełȂꍇɂ́AuNy[W߂B
				return "/spread/blank.html";
			}
			

			// [hI
			// 1. ChartC[Wt@C\pJSPĂяoAHTMLŃC[W\@
			// 2. ChartC[Wt@C𒼐ڏo͂@
			String chartDispMode = helper.getRequest().getParameter("chartDispMode");
			if(outXMLMode.equals(chartDispMode)) {
				// ChartCreatorIuWFNgArequest IuWFNgɕۑ
				helper.getRequest().setAttribute("chartCreator", chartCreator);
				return outJSPPage;				
			} else if (outImageMode.equals(chartDispMode)) {
				// C[W𒼐ڏo
				chartCreator.outDirectPNGChart(helper.getResponse());
				return null;	
			} else {
				throw new IllegalArgumentException();
			}

	}
}
