/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresAxisMemberDAO.java
 *  Fo[IuWFNg̉iǗNXłB
 *
 *  쐬: 2004/01/14
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import org.apache.log4j.Logger;

import openolap.viewer.Axis;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;


/**
 *  NXFPostgresAxisMemberDAO<br>
 *  Fo[IuWFNg̉iǗNXłB
 */
public abstract class PostgresAxisMemberDAO implements AxisMemberDAO {

	// ********** CX^Xϐ **********

	/** MOIuWFNg */
	private Logger log = Logger.getLogger(PostgresAxisMemberDAO.class.getName());

	// ********** ۃ\bh **********

	/**
	 * ^ꂽ̃fBVo[iB
	 * @param report |[gIuWFNg
	 * @param reportID |[gID
	 *                ̃p[^NULL̏ꍇAReportIuWFNg|[gIDŎo[ۑB
	 *                  NULLł͂Ȃꍇ́AreportIDp[^̒lŎo[ۑB
	 * @param axis IuWFNg
	 * @param conn ConnecionIuWFNg
	 * @exception SQLException ɗO
	 */
	public abstract void saveAxisMember(Report report, String reportID, Axis axis, Connection conn) throws SQLException;

	/**
	 * fBVo[f[^\[X̏ƂɐAfBVIuWFNg"selectedMemberDrillStat"ɐݒ肷B
	 * @param report |[gIuWFNg
	 * @param axis IuWFNg
	 * @param commonSettings AvP[V̋ʐݒ킷IuWFNg
	 * @exception SQLException ɗO
	 */
	public abstract void applyAxis(Report report, Axis axis, CommonSettings commonSettings) throws SQLException;

	// ********** \bh **********

	/**
	 * f[^\[XɕۑςĂ鎲o[擾B
	 * @param report |[gIuWFNg
	 * @param axis IuWFNg
	 */
	public String selectSaveDataSQL(Report report, Axis axis ) {

		String SQL = "";
		SQL =  "";
		SQL += "select ";
		SQL += "    report_id, ";
		SQL += "    axis_id, ";
		SQL += "    dimension_seq, ";
		SQL += "    member_key, ";
		SQL += "    selectedFLG, ";
		SQL += "    drilledFLG, ";
		SQL += "    measure_member_type_id ";
		SQL += "from ";
		SQL += "    oo_v_axis_member ";
		SQL += "where ";
		SQL += "    report_id=" + report.getReportID() + " and ";
		SQL += "    axis_id=" + axis.getId() + " ";
		SQL += "order by ";
		SQL += "    member_key";

		return SQL;
	}

	/**
	 * w肳ꂽ|[ĝׂĂ̎̎o폜B
	 * @param report |[gIuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void deleteAxisMember(Report report, Connection conn) throws SQLException {

		String SQL = "";
		SQL =  "";
		SQL += "delete from oo_v_axis_member ";
		SQL += "where ";
		SQL += "    report_id=" + report.getReportID();

		Statement stmt = null;
		try {
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(delete all axes members)F\n" + SQL);
			}
			stmt.executeUpdate(SQL);
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if(stmt != null) {
					stmt.close();
				}
			} catch (SQLException e) {
				throw e;
			}
		}
	}

	/**
	 * w肳ꂽ|[g̎w肳ꂽ̃o폜B
	 * @param report |[gIuWFNg
	 * @param axis IuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void deleteAxisMember(Report report, Axis axis, Connection conn) throws SQLException {

		deleteAxisMember(report.getReportID(), axis.getId(), conn);

	}


	/**
	 * w肳ꂽ|[g̎w肳ꂽ̃o폜B
	 * @param reportID |[gID
	 * @param axis IuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void deleteAxisMember(String reportID, String axisID, Connection conn) throws SQLException {

		String SQL = "";
		SQL =  "";
		SQL += "delete from oo_v_axis_member ";
		SQL += "where ";
		SQL += "    report_id=" + reportID + " and ";
		SQL += "    axis_id=" + axisID;

		Statement stmt = null;
		try {
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(delete specified axis members)F\n" + SQL);
			}
			stmt.executeUpdate(SQL);
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if(stmt != null) {
					stmt.close();
				}
			} catch (SQLException e) {
				throw e;
			}
		}
	}





}
