/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresRReportDAO.java
 *  F|[gIuWFNg̉iǗNXłB
 *
 *  쐬: 2005/01/07
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

import org.apache.log4j.Logger;

import openolap.viewer.common.StringTool;
import openolap.viewer.common.StringTool2;
import openolap.viewer.controller.RequestHelper;

/**
 *  NXFPostgresRReportDAO
 *  F|[gIuWFNg̉iǗNXłB
 */
public class PostgresRReportDAO implements RReportDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	Connection conn = null;

	/** DAOFactoryIuWFNg */
	DAOFactory daoFactory = DAOFactory.getDAOFactory();

	/** MOIuWFNg */
	private Logger log = Logger.getLogger(PostgresRReportDAO.class.getName());

	// ********** RXgN^ **********

	/**
	 * |[gIuWFNg̉iǗIuWFNg𐶐܂B
	 */
	PostgresRReportDAO(Connection conn) {
		this.conn = conn;
	}

	/**
	 * R|[gIuWFNgXML𐶐B
	 * @return R|[gpXMLi[StringBufferIuWFNg
	 * @exception SQLException ɗO
	 */
	public StringBuffer getRReportXML(RequestHelper helper) throws SQLException {

		// ev[gXMLAsSQL擾
		String templateXMLString = null;	// ev[gXML
		String getDataSQL        = null;	// SQL擾


		  // source ̒lɂAev[gXMLASQL̎擾ύX

		  String source = helper.getRequest().getParameter("source"); // ev[gXMLASQL̎擾
	
		  if ( "post".equals(source) ) { // 擾F|Xg
			  templateXMLString = helper.getRequest().getParameter("templateXML");
			  getDataSQL = helper.getRequest().getParameter("getDataSQL");
		  } else if ( "session".equals(source) ) { // 擾FZbV
			  templateXMLString = (String) helper.getRequest().getSession().getAttribute("RsourceXML");
			  getDataSQL        = (String) helper.getRequest().getSession().getAttribute("Rsql");
		  } else if ( "db".equals(source) ) { // 擾Ff[^x[X

			  String sourceTable = "oo_v_report";// ev[gXML,SQL ̎擾e[u
			  String reportID    = helper.getRequest().getParameter("rId"); // sourceTable ̍iݏi|[gIDj

			  ReportDAO reportDAO = daoFactory.getReportDAO(conn);
			  HashMap<String, String> hashMap = reportDAO.getTemplateInfo(sourceTable, reportID);

			  templateXMLString = hashMap.get("templateXMLString");
			  getDataSQL        = hashMap.get("getDataSQL");

		  } else {
			  throw new UnsupportedOperationException();
		  }
		

//System.out.println("==========================================================================================================");
//System.out.println("templateXMLString:" + templateXMLString);
//System.out.println("getDataSQL:" + getDataSQL);
//System.out.println("==========================================================================================================");

		  StringTool2 stTool2 = new StringTool2(templateXMLString);
	
		  // XMLuΏە݂̂؂o
		  String replaceString = stTool2.getInnerDataNodeString();
  //		String replaceString = "<row NXID='%%NXID%%' NXV[g='%%NXV[g%%'/>";
  //		String replaceString = "<row NXID--11--='%%NXID--11--%%' NXV[g--2--='%%NXV[g--2--%%' t@~[ID='%%t@~[ID%%' t@~[V[g='%%t@~[V[g%%' v_NgID='%%v_NgID%%' v_NgV[g='%%v_NgV[g%%'/>";
		  StringTool stTool = new StringTool(replaceString);
//System.out.println(replaceString);
	
		  // SQLs
		  Statement stmt = conn.createStatement();
		  ResultSet rset = stmt.executeQuery (getDataSQL);
	
		  // ev[gwlkɎ擾ʂ𖄂ߍ񂾂wlk𐶐AJSPł̏o͗prequestIuWFNg֕ۑB
		  StringBuffer dataXMLText = new StringBuffer();
	
		  // uȑOi[
		  dataXMLText.append(stTool2.getBeforeDataNodeString());
		  dataXMLText.append(StringTool2.dataMarkStartStr);
	
		  // u(data^O)i[
		  int cnt = stTool.getdivCount();
		  String[] divXMLStr = stTool.getXMLString();
		  String[] divSQLStr = stTool.getSQLString();
	
		  while (rset.next ()){
			  String resultXML="";
			  for(int i=0;i<cnt;i++){
				  resultXML+=divXMLStr[i]+rset.getString(divSQLStr[i]);
			  }
			  resultXML+=divXMLStr[cnt];
			  dataXMLText.append(resultXML);
		  }
//	  dataXMLText.append(stTool.dispStr());

		  // uȍ~i[
		  dataXMLText.append(StringTool2.dataMarkEndStr);
		  dataXMLText.append(stTool2.getAfterDataNodeString());
			
		return dataXMLText;
	}

}
