/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.export
 *  t@CFExportReport.java
 *  F|[g̃GNX|[gsۃNXłB
 *
 *  쐬: 2004/01/31
 */
package openolap.viewer.export;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.naming.NamingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;

import org.xml.sax.SAXException;


import openolap.viewer.Axis;
import openolap.viewer.Edge;
import openolap.viewer.common.StringUtil;
import openolap.viewer.controller.RequestHelper;

/**
 *  ۃNXFExportReport<br>
 *  F|[g̃GNX|[gsۃNXłB
 */
public abstract class ExportReport {

	// ********** \bh **********

	/**
	 * GNX|[gs
	 * @param helper RequestHelperIuWFNg
	 * @return dispatchJSP/HTML̃pX
	 * @exception SQLException ɗO
	 * @exception NamingException ɗO
	 * @exception FileNotFoundException ɗO
	 * @exception UnsupportedEncodingException ɗO
	 * @exception IOException ɗOUnsupportedEncodingException
	 */
	public abstract String exportReport(RequestHelper helper) throws SQLException, NamingException, FileNotFoundException, UnsupportedEncodingException, IOException, ParserConfigurationException, SAXException, TransformerException, XPathExpressionException;


	// ********** protected\bh **********

	/**
	 * @param edge
	 * @param axis
	 * @param rowIndex
	 * @return o͂
	 */
	protected boolean isPrintPoint(Edge edge, Axis axis, int rowIndex) {
		Integer nextComboNums = edge.getNextAxesMembersComboNums(axis);
		
		if (nextComboNums == null) {// ŏIȉꍇAɕ\Ώ
			return true;
		} else { // ŏIiȊȌꍇ
			if ( (rowIndex % nextComboNums.intValue() == 0)) {//Z̐擪Index
				return true;
			} else {
				return false;
			}
		}
	}

	/**
	 * sE񃁃õZ߂B
	 * @param edge GbW킷IuWFNg
	 * @param axis 킷IuWFNg
	 * @return ZKvȐ
	 */
	protected int getCellMergeNum(Edge edge, Axis axis) {

		Integer cellMergeNumber = edge.getNextAxesMembersComboNums(axis);
		int mergeNum;
		if (cellMergeNumber != null) {
			mergeNum = cellMergeNumber.intValue()-1;
		} else {
			mergeNum = 0;
		}
		
		return mergeNum;
	}

	/**
	 * o[SpreadIndex߂B
	 * @param edge GbW킷IuWFNg
	 * @param axis 킷IuWFNg
	 * @param x n_ƂȂSpreadIndex
	 * @return ZKvȐ
	 */
	protected int getNextSpreadIndex(Edge edge, Axis axis, int x) {

		Integer cellMergeNumber = edge.getNextAxesMembersComboNums(axis);
		int mergeNum;
		if (cellMergeNumber != null) {
			mergeNum = cellMergeNumber.intValue();
		} else {
			mergeNum = 1;
		}
		return ( x + mergeNum );
	}

	/**
	 * ^ꂽȑO̒ȋgݍ킹߂B
	 * @param edge GbW킷IuWFNg
	 * @param axis 킷IuWFNg
	 * @return ZKvȐ
	 */
	protected int getBeforeComboNum(Edge edge, Axis axis) {

		Integer axisMemRepeatNumber = edge.getBeforeAxesMembersComboNums(axis);

		int axisMemRepeatNum;
		if (axisMemRepeatNumber != null) {
			axisMemRepeatNum = axisMemRepeatNumber.intValue();
		} else {
			axisMemRepeatNum = 1;	// 0ȉꍇAxJԂ
		}
		return axisMemRepeatNum;
	}

	/**
	 * w肳ꂽi̎oΏہi\ΏۊOjǂmFB<br>
	 * O̍s/ɔzuꂽoKey̑gݍ킹ƎKey̑gݍ킹rA
	 * w肳ꂽiтʂ̒iKeyقȂꍇ͕\ΏہAꍇ͕\ΏۊOƂ
	 * @param beforeKeys ȑÕo[L[̑gݍ킹
	 * @param keys o[L[̑gݍ킹
	 * @param hieIndex GbW̒iCfbNX
	 * @return ΏۂłtrueAȂfalse߂
	 */
	protected boolean isJoinMember(String beforeKeys, String keys, int hieIndex) {

		if (beforeKeys == null) {
			return false;
		}

		ArrayList<String> keyList = StringUtil.splitString(keys, ";");
		ArrayList<String> beforeKeyList = StringUtil.splitString(beforeKeys, ";");

		for (int i = 0; i < hieIndex+1; i++) {	// w肳ꂽiт̏iKey͓mF
			String key = keyList.get(i);
			String beforeKey = beforeKeyList.get(i);
			if (!key.equals(beforeKey)){
				return false;
			}
		}
		return true;
	}


}
