/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.common
 *  t@CFCommonUtils.java
 *  F[eBeBNXłB
 *
 *  쐬: 2004/01/14
 */
package openolap.viewer.common;

import java.util.ArrayList;
import java.util.Enumeration;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

import openolap.viewer.Report;
import openolap.viewer.User;
import openolap.viewer.controller.RequestHelper;

import org.apache.log4j.Logger;

/**
 *  NXFCommonUtils<br>
 *  F[eBeBNXłB
 */
public class CommonUtils {

	// ********** \bh **********

	/**
	 * ^ꂽbooleantrueł"1"Afalseł"0"߂B
	 * @param b boolean
	 * @return "1"(true) 邢 "0"(false)
	 */
	public static String boolToFLG(boolean b){
		if (b){
			return "1";
		} else {
			return "0";
		}
	}

	/**
	 * ^ꂽString"1"łtrueA"0"łfalse߂B
	 * @param sting StringIuWFNg
	 * @return true("1") 邢 false("0")
	 */
	public static boolean FLGTobool(String string) {
		if ("1".equals(string)) {
			return true;
		} else {
			return false;
		}
	}


	/**
	 * zArrayListɊi[B
	 * @param objects z
	 * @return ArrayListIuWFNg
	 */
	public static ArrayList<Object> arrayToArrayList(Object[] objects) {
		if (objects == null) {
			throw new IllegalArgumentException();
		}

		ArrayList<Object> arrayList = new ArrayList<Object>();
		for (int i = 0; i < objects.length; i++ ){
			arrayList.add(objects[i]);
		}
		return arrayList;
	}

	/**
	 * ExceptionAStackTrace擾B
	 * @param Exception z
	 * @return IuWFNg
	 */
	public static String getStackTrace(Exception e) {
		
		StackTraceElement[] stElement = e.getStackTrace();
		StringBuffer stb = new StringBuffer();
		for (int i=0; i<stElement.length; i++ ) {
			stb.append("    at " + stElement[i].toString() + "\n");
		}

		return stb.toString();
	}

	/**
	 * RequestAKeyValue킷擾B
	 * @param request NGXgIuWFNg
	 * @return StringBufferIuWFNg
	 */
	public static StringBuffer getRequestParameters(ServletRequest request) {

		StringBuffer params = new StringBuffer(512);
		String sep = System.getProperty("line.separator");

		params.append("Request Parameter Lists start ====================== " + sep);

		Enumeration e = request.getParameterNames();
		while (e.hasMoreElements()) {
			String attrName  = (String) e.nextElement();
			String attrValue = request.getParameter(attrName);
			
			params.append(attrName + ": " + attrValue + sep);
		}

		params.append("Request Parameter Lists end   ====================== " + sep);

		return params;
	}

	/**
	 * Session擾B
	 * @param request NGXgIuWFNg
	 * @return StringBufferIuWFNg
	 */
	public static StringBuffer getSessionParameters(HttpServletRequest request) {
		
		StringBuffer sessionInfo = new StringBuffer(512);
		String sep = System.getProperty("line.separator");
		
		sessionInfo.append("Session Information start ====================== " + sep);

		Enumeration e = request.getSession().getAttributeNames();
		while (e.hasMoreElements()) {
			String attrName  = (String) e.nextElement();
			String attrValue = request.getSession().getAttribute(attrName).toString();
			
			sessionInfo.append("<session attribue name>" + attrName + sep);
			sessionInfo.append(attrValue + sep);

		}

		sessionInfo.append("Session Information end   ====================== " + sep);
		
		return sessionInfo;
	}


	/**
	 * Oo͂B
	 * @param RequestHelper NGXgwp[IuWFNg
	 * @param log MOIuWFNg
	 * @param args1Key   vȃbZ[W
	 * @param args1Value vȃbZ[W̒l
	 */
	public static void loggingMessage(RequestHelper helper, Logger log, String args1Key, String args1Value) {
		
		if(log.isInfoEnabled()) {	// Oo
			User user = (User) helper.getRequest().getSession().getAttribute("user");
			Report report = (Report)helper.getRequest().getSession().getAttribute("report");

			String sep = System.getProperty("line.separator");

			log.info(args1Key + ": " + args1Value + sep +
					 "ReportID: " + report.getReportID() + sep +
					 "UserID: " + user.getUserID()
					 );

		}

	}

}
