/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFInitializeStatus.java
 *  FAvP[V̏sNXłB
 *
 *  쐬: 2004/01/12
 */
package openolap.viewer.controller;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import openolap.viewer.common.CommonSettings;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.MeasureMemberTypeDAO;
import openolap.viewer.MeasureMemberType;

/**
 *  NXFInitializeStatus<br>
 *  FAvP[V̏sNXłB
 */
public class InitializeStatus {

	/**
	 * AvP[V̏sAʐݒServletContext֓o^B
	 * @param context ServletContextIuWFNg
	 * @exception SQLException ɗO
	 * @exception NamingException ɗO
	 */
	public static void initApStatus(HttpServletRequest request, ServletContext context) throws SQLException, NamingException {

		Connection conn = null;

		if ( context.getAttribute("apCommonSettings") == null ) {

			DAOFactory daoFactory = DAOFactory.getDAOFactory();
			if (conn == null){
				conn = daoFactory.getConnection((String)request.getSession().getAttribute("connectionPoolName"),
												(String)request.getSession().getAttribute("searchPathName"));
			}

			CommonSettings commonSettings = CommonSettings.getCommonSettings();

			try {
				MeasureMemberTypeDAO measureMemberTypeDAO = daoFactory.getMeasureMemberTypeDAO(conn);
				ArrayList<MeasureMemberType> measureMemberTypeList = measureMemberTypeDAO.getMeasureMemberTypeList();

				commonSettings.addMeasureMemberTypeList(measureMemberTypeList);

				// ServletContext֓o^
				context.setAttribute("apCommonSettings", commonSettings);
				
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (conn != null) {
						conn.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}
	}
}
