/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFAxisMember.java
 *  F
 *
 *  쐬: 2004/01/11
 */
package openolap.viewer;

import java.io.Serializable;

/**
 *  NXFAxisMember
 *  F
 */
public abstract class AxisMember implements Serializable {

	protected final String id;				//id(0start)
	protected final String uniqueName;		//j[N
	protected final int level;
	protected boolean isSelected = true;		//ZN^őIĂ郁o[

	// ********** RXgN^ **********

	public AxisMember(String id, String uniqueName, int level) {
		this.id = id;
		this.uniqueName = uniqueName;
		this.level = level;
		this.isSelected = true;
	}

	// ********** \bh **********

	public abstract String getSpecifiedDisplayName(Axis axis);
	public abstract String getSpecifiedIndentedDisplayName(Axis axis);
	public abstract String getIndentedShortName();
	public abstract String getIndentedLongName();

	// ********** setter **********

	public void setIsSelected(boolean selectedFLG) {
		this.isSelected = selectedFLG;
	}

	// ********** getter **********

	public String getId() {
		return this.id;
	}
	public String getUniqueName() {
		return this.uniqueName;
	}
	public boolean isSelected() {
		return this.isSelected;
	}

	public int getLevel() {
		return level;
	}
}
