/*
 * 쐬: 2003/12/29
 *
 */

package openolap.viewer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

import openolap.viewer.common.Constants;

/**
 */
public abstract class Edge implements Serializable {

	final private ArrayList axisList;	// Xg

	// ********** RXgN^ **********

	public Edge(ArrayList axisList){
		this.axisList = axisList;
	}

	public Edge(Axis axis) {
		this.axisList = new ArrayList();
		this.axisList.add(axis);
	}


	// ********** abstract \bh **********

	public abstract String getPosition();

	// ********** ÓI\bh **********

	public static Edge getTheEdge(String position, ArrayList edgeList) {
		if ((position == null) || (edgeList == null)) { throw new IllegalArgumentException();}
		if (edgeList.size() < 2) { throw new IllegalStateException();}

		if (position.equals(Constants.Col)) {
			return (Edge)edgeList.get(0);
		} else if (position.equals(Constants.Row)) {
			return (Edge)edgeList.get(1);
		} else if (position.equals(Constants.Page)) {
			return (Edge)edgeList.get(2);
		} else {
			throw new IllegalStateException();
		}
	}


	// ********** \bh **********

	public boolean hasThisAxis(Axis oAxis){
		if (oAxis == null){ return false; }
		Iterator it = this.getAxisList().iterator();
		while (it.hasNext()) {
			Axis axis = (Axis) it.next();
			if (axis.getId() == oAxis.getId()) {
				return true;
			}
		}
		return false;		
	}
	public boolean hasThisAxis(String axisId) {
		if (axisList == null){ return false; }
		Iterator it = this.getAxisList().iterator();
		while (it.hasNext()) {
			Axis axis = (Axis) it.next();
			if (axis.getId() == axisId) {
				return true;
			}
		}
		return false;
	}

	// GbW̎iɔzuꂽ̃o(ZN^ŏOĂ̂͊܂܂Ȃ)Ԃ
	// Dimension̎oXg͈ꎞIɎgpł邱ƂɒӁB
	public Integer getNextAxisMemberNums(Axis axis) {
		if (axis == null) { throw new IllegalArgumentException(); }
		if (this.hasThisAxis(axis) == false) { throw new IllegalArgumentException(); }
		Iterator it = this.getAxisList().iterator();
		int i = 0;
		while (it.hasNext()) {
			Axis tmpAxis = (Axis) it.next();
			if (axis.getId().equals(tmpAxis.getId())) {
				if(i == (this.getAxisList().size()-1)) { // ŏIiw肳ꂽꍇ
					return null;
				} else {

					Axis nextAxis = (Axis)it.next();
//System.out.println("nextAxis:" + nextAxis.getName());
					Integer nextAxisMemberNums = null;
					if (nextAxis.isUsedSelecter()) {// ZN^ɂiݒ
						Iterator nextAxisMemIt = nextAxis.getAxisMemberList().iterator();
						int count = 0;
						while (nextAxisMemIt.hasNext()) {
							AxisMember axisMember = (AxisMember) nextAxisMemIt.next();
							if (axisMember.isSelected()){
								count++;
							}
						}
						nextAxisMemberNums = new Integer(count);
					} else { // ZN^ɂiݒł͂Ȃ

						nextAxisMemberNums = new Integer( nextAxis.getAxisMemberList().size());
					}

					return nextAxisMemberNums;
				}
			}
			i++;
		}
		return null;
	}

	// GbW̎iȍ~ɔzuꂽ̃o(ZN^ŏOĂ̂͊܂܂Ȃ)̐ςԂ
	// Dimension̎oXg͈ꎞIɎgpł邱ƂɒӁB
	public Integer getNextAxesMembersComboNums(Axis axis) {
		if (axis == null) { throw new IllegalArgumentException(); }
		if (this.hasThisAxis(axis) == false) { throw new IllegalArgumentException(); }
		Iterator it = this.getAxisList().iterator();
		int i = 0;
		while (it.hasNext()) {
			Axis tmpAxis = (Axis) it.next();
			if (axis.getId().equals(tmpAxis.getId())) {
				if(i == (this.getAxisList().size()-1)) { // ŏIiw肳ꂽꍇ
					return null;
				} else {

//System.out.println("nextAxis:" + nextAxis.getName());
					int nextAxesComboNums = 1;
					while (it.hasNext()) {
						Axis nextAxis = (Axis)it.next();

						if (nextAxis.isUsedSelecter()) {// ZN^ɂiݒ
							Iterator nextAxisMemIt = nextAxis.getAxisMemberList().iterator();
							int count = 0;
							while (nextAxisMemIt.hasNext()) {
								AxisMember axisMember = (AxisMember) nextAxisMemIt.next();
								if (axisMember.isSelected()){
									count++;
								}
							}
							nextAxesComboNums = nextAxesComboNums * count;
						} else { // ZN^ɂiݒł͂Ȃ
	
							nextAxesComboNums = nextAxesComboNums * nextAxis.getAxisMemberList().size();
						}
					}

					return new Integer(nextAxesComboNums);
				}
			}
			i++;
		}
		return null;
	}


	// GbW̎w肳ꂽOɔzuꂽ̃o(ZN^ŏOĂ̂͊܂܂Ȃ)̐ς߂
	// Dimension̎oXg͈ꎞIɎgpł邱ƂɒӁB
	public Integer getBeforeAxesMembersComboNums(Axis axis) {
		if (axis == null) { throw new IllegalArgumentException(); }
		if (this.hasThisAxis(axis) == false) { throw new IllegalArgumentException(); }
		Iterator it = this.getAxisList().iterator();
		ArrayList beforeAxisList = new ArrayList();
		while (it.hasNext()) {
			Axis tmpAxis = (Axis) it.next();
			if (axis.getId().equals(tmpAxis.getId())) {
				if (beforeAxisList.size() == 0) {// 0iڂw肳ꂽꍇ
					return null;
				} else {
					int beforeAxesComboNums = 1;

					Iterator beforeAxisIt = beforeAxisList.iterator();
					while (beforeAxisIt.hasNext()) {
						Axis beforeAxis = (Axis) beforeAxisIt.next();
						if(beforeAxis.isUsedSelecter()) { // ZN^ɂiݒ
							Iterator beforeAxisMemIt = beforeAxis.getAxisMemberList().iterator();
							int count = 0;
							while (beforeAxisMemIt.hasNext()) {
								AxisMember axisMember = (AxisMember) beforeAxisMemIt.next();
								if (axisMember.isSelected()) {
									count++;
								}
							}
							beforeAxesComboNums = beforeAxesComboNums * count;

						} else {// ZN^ɂiݒł͂Ȃ
							beforeAxesComboNums = beforeAxesComboNums * beforeAxis.getAxisMemberList().size();
						}
					}
					return new Integer(beforeAxesComboNums);
				}
			}
			beforeAxisList.add(tmpAxis);
		}
		return null;
	}


	public int getAxisIndexInEdge(Axis oAxis){
		if (oAxis == null){ return -1; }
		Iterator it = this.getAxisList().iterator();
		int i = 0;
		while (it.hasNext()) {
			Axis axis = (Axis) it.next();
			if (axis.getId() == oAxis.getId()) {
				return i;
			}
			i++;
		}
		return -1;
	}
	public int getAxisIndexInEdge(String axisId){
		if (axisId == null) { return -1; }
		Iterator it = this.getAxisList().iterator();
		int i = 0;
		while (it.hasNext()) {
			Axis axis = (Axis) it.next();
			if (axis.getId() == axisId) {
				return i;
			}
			i++;
		}
		return -1;
	}

	public boolean investigateTimeDimension() {
		Iterator it = this.axisList.iterator();
		while (it.hasNext()) {
			Axis axis = (Axis) it.next();
			
			if(!axis.isMeasure()) {
				Dimension dim = (Dimension)axis;
				if(dim.isTimeDimension()){
					return true;
				}
			}
		}
		return false;
	}

	public Measure getMeasure() {
		Iterator it = this.axisList.iterator();
		while (it.hasNext()) {
			Axis axis = (Axis) it.next();
			
			if(axis.isMeasure()) {
				return (Measure)axis;
			}
		}	
		return null;
	}


	public void addAxis(Axis axis) {
		if (axis == null){ throw new IllegalArgumentException(); }

		this.axisList.add(axis);
	}

	public void clearAxis() {
		this.axisList.clear();
	}

	// ********** Getter \bh **********

	public ArrayList getAxisList() {
		return axisList;
	}

}
