/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.common
 *  t@CFCommonSettings.java
 *  F
 *
 *  쐬: 2004/01/12
 */
package openolap.viewer.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

import openolap.viewer.MeasureMemberType;

/**
 *  NXFCommonSettings
 *  F
 */
public class CommonSettings implements Serializable {

	static final CommonSettings commonSettings = new CommonSettings(CommonUtils.FLGTobool(Messages.getString("InitializeStatus.valueXmlContainsAxesInfoFLG")));

	final private ArrayList measureMemberTypeList = new ArrayList();
	final private boolean valueXmlContainsAxesInfo;
	
	// ********** RXgN^ **********

	private CommonSettings (boolean valueXmlContainsAxesInfo) {
		this.valueXmlContainsAxesInfo = valueXmlContainsAxesInfo;
	}

	// ********** static\bh **********

	public static CommonSettings getCommonSettings() {
		return commonSettings;
	}

	// ********** \bh **********

	public void addMeasureMemberTypeList(MeasureMemberType measureMemberType) {
		this.measureMemberTypeList.add(measureMemberType);
	}
	
	public void addMeasureMemberTypeList(ArrayList measureMemberTypeList) {
		if(measureMemberTypeList == null) { throw new IllegalArgumentException(); }

		Iterator it = measureMemberTypeList.iterator();
		while (it.hasNext()) {
			MeasureMemberType measureMemberType = null;
			Object obj = (Object) it.next();
			if (obj instanceof MeasureMemberType) {
				measureMemberType = (MeasureMemberType) obj;
			} else {
				throw new IllegalArgumentException();
			}
			this.measureMemberTypeList.add(measureMemberType);
		}
	}

	// W[o^CvIDƂɃW[o^CvIuWFNgԂ
	public MeasureMemberType getMeasureMemberTypeByID(String typeId) {
		Iterator it = this.measureMemberTypeList.iterator();
		while (it.hasNext()){
			MeasureMemberType measureMemberType = (MeasureMemberType) it.next();
			if(typeId.equals(measureMemberType.getId())) {
				return measureMemberType;
			}
		}
		return null;
	}

	public MeasureMemberType getFirstMeasureMemberType() {
		return (MeasureMemberType)measureMemberTypeList.get(0);
	}

	// ********** Getter \bh **********

	public ArrayList getMeasureMemberTypeList() {
		return measureMemberTypeList;
	}
	public boolean getValueXmlContainsAxesInfo() {
		return valueXmlContainsAxesInfo;
	}


}
