/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFExportReportCommand.java
 *  F
 *
 *  쐬: 2004/01/31
 */
package openolap.viewer.controller;

import java.io.IOException;

import javax.servlet.ServletException;

import openolap.viewer.User;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.export.ExportReport;
import openolap.viewer.export.ExportReportFactory;
import openolap.viewer.manager.CellDataManager;

/**
 *  NXFExportReportCommand
 *  F
 */
public class ExportReportCommand implements Command {

	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException {

		// fBVoAZf[^擾SessionɈꎞۑ
		CellDataManager.saveRequestParamsToSession(helper);

		User user = (User) helper.getRequest().getSession().getAttribute("user");

		// GNX|[gs
		ExportReportFactory exportReportFactory = new ExportReportFactory();
		ExportReport exportReport = exportReportFactory.getExportReport(user);
		String page = exportReport.exportReport(helper);

		return page;
	}

}
