/*
 * 쐬: 2004/01/05
 *
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

import java.util.ArrayList;

import javax.servlet.ServletException;

import openolap.viewer.common.CommonSettings;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.manager.CellDataManager;

/**
 */
public class GetDataInfoCommand implements Command {

	private RequestHelper requestHelper = null;
	private DAOFactory daoFactory = null;

	// ********** \bh **********

	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException {

		this.requestHelper = helper;
		this.daoFactory = DAOFactory.getDAOFactory();

		Connection conn = null;
		conn = daoFactory.getConnection();

		try {
			// ^ꂽ擾ƂCellDataIuWFNgXg(l̓tH[}bgt)擾requestIuWFNgɈꎞۑ
			ArrayList cellDataList = CellDataManager.selectCellDatas(this.requestHelper, conn, true);

			helper.getRequest().setAttribute("cellDataList", cellDataList);

		} catch (SQLException e) {
			e.printStackTrace();
		} catch (Exception e) { 
			e.printStackTrace();
		} finally {
			// RlNV̊J
			try {
				if(conn != null) {
					conn.close();
				}
			} catch (SQLException e) {
				e.printStackTrace();
			}

		}

		// SessionAf[^擾p̃^폜
		CellDataManager.clearRequestParamForGetDataInfo(this.requestHelper); 

		return "/spread/dataInfo.jsp";
	}


}
