/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFRenewHtmlActCommand.java
 *  F
 *
 *  쐬: 2004/01/19
 */
package openolap.viewer.controller;

import java.io.IOException;

import javax.servlet.ServletException;

import openolap.viewer.common.CommonSettings;
import openolap.viewer.dao.ColorDAO;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.ReportDAO;

/**
 *  NXFRenewHtmlActCommand
 *  F
 */
public class RenewHtmlActCommand implements Command {

	private final String registColorSettingsMode = "registColorSetings";


	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException {

		String mode = (String)helper.getRequest().getParameter("mode");
		if( registColorSettingsMode.equals(mode) ) {

			// ̔zuXV
			ReportDAO reportDAO = DAOFactory.getDAOFactory().getReportDAO(null);
			reportDAO.registAxisPosition(helper, commonSettings);

			// FݒXV
			ColorDAO colorDAO = DAOFactory.getDAOFactory().getColorDAO(null);
			colorDAO.registColor(helper, commonSettings);

		}
		return "/spread/spread.html";
	}

}
