/*
 * 쐬: 2004/01/05
 *
 */
package openolap.viewer.controller;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author Administrator
 *
 */
public class RequestHelper {

	HttpServletRequest request = null;
	HttpServletResponse response = null;
	ServletConfig config = null;

	public RequestHelper (HttpServletRequest request, HttpServletResponse response, ServletConfig config) {
		this.request = request;
		this.response = response;
		this.config = config;
	}

	public Command getCommand(){
	
		Command command = null;

		String action = this.request.getParameter("action");

		// OCς݂`FbN
		if ( request.getSession().getAttribute("user") == null) {
			if (!action.equals("login")) {
				return new InvalidateSessionCommand();
			}
		}


		if (action != null){

			// |[g\
			if (action.equals("displayNewReport")) {		//|[g\
				command = new DisplayNewReportCommand();
			} else if (action.equals("getReportHeader")) {	//|[gIuWFNgуwb_
				command = new GetReportHeaderCommand();
			} else if(action.equals("loadClientInitAct")){	//|[g擾R}h擾
				command = new LoadClientInitActCommand();
			} else if (action.equals("getReportInfo")){	//|[g(|[gAAo)
				command = new GetReportInfoCommand();
			} else if (action.equals("renewHtmlAct")) {	//HTMLBODYXV
				command = new RenewHtmlActCommand();		

			// Fݒ
			} else if (action.equals("loadColorAct")){		//FݒR}h擾
				command = new LoadColorActCommand();
			} else if (action.equals("getColorInfo")){		//Fݒ擾
				command = new GetColorInfoCommand(); 

			// |[gւ̃f[^\
			} else if (action.equals("loadDataAct")) {		//|[gւ̃f[^}R}h擾
															//(\AXCXAh_E)
				command = new LoadDataActCommand();
			} else if (action.equals("getDataInfo")) {		//|[g̃f[^̏W擾
				command = new GetDataInfoCommand();

			// ZN^
			} else if (action.equals("displaySelecter")) {			//ZN^[ t[\
				command = new DisplaySelecterCommand();
			} else if (action.equals("displaySelecterHeader")){	//ZN^[ wb_[\
				command = new DisplaySelecterHeaderCommand();
			} else if (action.equals("displaySelecterBody")){		//ZN^[ {fB[\
				command = new DisplaySelecterBodyCommand();
			} else if (action.equals("getAxisMemberInfoByAxisID")) {// oXML擾
				command = new GetAxisMemberInfoByAxisIDCommand();				
			} else if (action.equals("registClientReportStatus")){	//NCAg̃|[gT[o[̃fɔfii͂Ȃj
				command = new RegistSelecterInfoCommand();
			} else if (action.equals("searchDimensionMember")){	//o(ZN^)
				command = new SearchDimensionMemberCommand();

			// |[gۑ
			} else if (action.equals("saveClientReportStatus")){	//NCAg̃|[gi
				command = new SaveClientReportStatusCommand();

			// OC
			} else if (action.equals("login")) {
				command = new LoginCommand();
			
			// OAEg
			} else if (action.equals("logout")) {	// OAEgs
				command = new LogoutCommand();

			// GNX|[g
			} else if (action.equals("exportReport")) {
				command = new ExportReportCommand();
			}
			
		}

		return command;
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public HttpServletResponse getResponse() {
		return response;
	}

	public ServletConfig getConfig() {
		return config;
	}

}
