/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFSaveClientReportStatusCommand.java
 *  F
 *
 *  쐬: 2004/01/14
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

import javax.servlet.ServletException;

import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.dao.AxisDAO;
import openolap.viewer.dao.ColorDAO;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.ReportDAO;

/**
 *  NXFSaveClientReportStatusCommand
 *  F
 */
public class SaveClientReportStatusCommand implements Command {

	private RequestHelper requestHelper = null;

	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException {

		String reportName = (String)helper.getRequest().getParameter("reportName");
		String folderID = (String)helper.getRequest().getParameter("folderID");

		// |[gۑꏊwtŕۑ
		if ( (!reportName.equals("")) && (!folderID.equals("")) ) {
			helper.getRequest().setAttribute("mode", "saveNewReport");
		}

		Connection conn = null;
		DAOFactory daoFactory = DAOFactory.getDAOFactory();
		conn = daoFactory.getConnection();

		// =========================================
		// ServerŕێĂ郌|[gfXV
		// =========================================

		// FݒXV
		ColorDAO colorDAO = daoFactory.getColorDAO(null);
		colorDAO.registColor(helper, commonSettings);

		// ̃õh
		AxisDAO axisDAO = daoFactory.getAxisDAO(null);
		axisDAO.registSelectedMemberAndDrillStat(helper, commonSettings);

		// |[gXV
		ReportDAO reportDAO = daoFactory.getReportDAO(null);
		reportDAO.registReport(helper, commonSettings);

		// =========================================
		// |[gݒi
		// =========================================
		Report report = (Report) helper.getRequest().getSession().getAttribute("report");
		try {
			conn.setAutoCommit(false);
			report.saveReport(conn);
			conn.commit();
		} catch (SQLException e) {
			try {
				if (conn != null){
					conn.rollback();
				}
				e.printStackTrace();
			} catch (SQLException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
		} catch (Exception e) {
			try {
				if (conn != null){
					conn.rollback();
				}
				e.printStackTrace();
			} catch (SQLException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
		} finally {
			try {
				if (conn != null) {
					conn.close();
				}

			} catch (SQLException e1) {
				e1.printStackTrace();
			}
		}

		// =========================================
		// I
		// =========================================
		if(report.isNewReport()) {
			report.setNewReport(false);
		}

		return "/spread/saveFinalize.jsp";
	}

}
