/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresAxisMemberDAO.java
 *  F
 *
 *  쐬: 2004/01/14
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import openolap.viewer.Axis;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;


/**
 *  NXFPostgresAxisMemberDAO
 *  F
 */
public abstract class PostgresAxisMemberDAO implements AxisMemberDAO {


	// ********** \bh **********

	public abstract void saveAxisMember(Report report, Axis axis, Connection conn) throws SQLException;
	public abstract void applyAxis(Report report, Axis axis, CommonSettings commonSettings) throws SQLException;


	public String selectSaveDataSQL(Report report, Axis axis ) {

		String SQL = "";
		SQL =  "";
		SQL += "select ";
		SQL += "    report_id, ";
		SQL += "    axis_id, ";
		SQL += "    dimension_seq, ";
		SQL += "    member_key, ";
		SQL += "    selectedFLG, ";
		SQL += "    drilledFLG, ";
		SQL += "    measure_member_type_id ";
		SQL += "from ";
		SQL += "    oo_v_axis_member ";
		SQL += "where ";
		SQL += "    report_id=" + report.getReportID() + " and ";
		SQL += "    axis_id=" + axis.getId() + " ";
		SQL += "order by ";
		SQL += "    member_key";
//System.out.println("apply axis member SQL:" + SQL);
		
		return SQL;
	}

	// w肳ꂽ|[ĝׂĂ̎̎o폜
	public void deleteAxisMember(Report report, Connection conn) throws SQLException {

		String SQL = "";
		SQL =  "";
		SQL += "delete from oo_v_axis_member ";
		SQL += "where ";
		SQL += "    report_id=" + report.getReportID();

		Statement stmt = null;
		try {
			stmt = conn.createStatement();
			stmt.executeUpdate(SQL);
		} catch (SQLException e) {
			throw e;
		} catch (Exception e) { 
			e.printStackTrace();
		} finally {
			try {
				if(stmt != null) {
					stmt.close();
				}
			} catch (SQLException e) {
				throw e;
			}
		}
	}

	// w肳ꂽ|[g̎w肳ꂽ̃o폜
	public void deleteAxisMember(Report report, Axis axis, Connection conn) throws SQLException {

		String SQL = "";
		SQL =  "";
		SQL += "delete from oo_v_axis_member ";
		SQL += "where ";
		SQL += "    report_id=" + report.getReportID() + " and ";
		SQL += "    axis_id=" + axis.getId();

		Statement stmt = null;
		try {
			stmt = conn.createStatement();
			stmt.executeUpdate(SQL);
		} catch (SQLException e) {
			throw e;
		} catch (Exception e) { 
			e.printStackTrace();
		} finally {
			try {
				if(stmt != null) {
					stmt.close();
				}
			} catch (SQLException e) {
				throw e;
			}
		}
	}

}
