/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresColorDAO.java
 *  F
 *
 *  쐬: 2004/01/15
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;

import openolap.viewer.Color;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.CommonUtils;
import openolap.viewer.common.StringUtil;
import openolap.viewer.controller.RequestHelper;

/**
 *  NXFPostgresColorDAO
 *  F
 */
public class PostgresColorDAO implements ColorDAO {

	Connection conn = null;

	// ********** RXgN^ **********
	PostgresColorDAO(Connection conn) {
		this.conn = conn;
	}

	// ********** \bh **********

	public void applyColor(Report report, Connection conn) throws SQLException {

		ArrayList colorList = new ArrayList();
		
		// SQL
		String SQL = "";
		SQL += "select ";
		SQL += "    edge_id_combo, ";
		SQL += "    edge_mem_key1, ";
		SQL += "    edge_mem_key2, ";
		SQL += "    edge_mem_key3, ";
		SQL += "    edge_mem_key4, ";
		SQL += "    edge_mem_key5, ";
		SQL += "    edge_mem_key6, ";
		SQL += "    headerFLG, ";
		SQL += "    html_color ";
		SQL += "from ";
		SQL += "    oo_v_color ";
		SQL += "where ";
		SQL += "    report_id=" + report.getReportID() + " ";
		SQL += "order by ";
		SQL += "    edge_id_combo";
//System.out.println("apply Color SQL:" + SQL);					
		
		// SQLs
		Statement stmt = null;
		ResultSet rs = null;
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(SQL);

			while ( rs.next() ) {

				// FÂꂽZ̍W\TreeMap쐬
				ArrayList axisIdList = StringUtil.splitString(rs.getString("edge_id_combo"),",");
				TreeMap axisIDAndMemberKeyMap = new TreeMap();

				Iterator axisIdIt = axisIdList.iterator();
				int i = 0;
				while (axisIdIt.hasNext()) {
					String axisId = (String) axisIdIt.next();									// ID
					String axisMemberKey = rs.getString("edge_mem_key"+Integer.toString(i+1));	// L̃o[Key
					axisIDAndMemberKeyMap.put(Integer.decode(axisId),axisMemberKey);
					i++;
				}
	
				// ColorIuWFNg𐶐
				Color color = new Color( axisIDAndMemberKeyMap, 		// axisIDAndMemberKeyMap 
										  CommonUtils.FLGTobool(rs.getString("headerFLG")), // isHeader
										  rs.getString("html_color"));	// HTMLColor

				// 쐬ColorIuWFNgArrayListɒǉ
				colorList.add(color);

			}	
	
		} catch (SQLException e) {
			throw e;
		} catch (Exception e){
			e.printStackTrace();
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}
		
		// |[gIuWFNgColorIuWFNg̏Wo^
		report.addColor(colorList);
		
		
	}

	public void registColor(RequestHelper helper, CommonSettings commonSettings) {

		// NCAgM擾
		HttpServletRequest request = helper.getRequest();
		String dtColorInfoListString = (String)request.getParameter("dtColorInfo");
		String hdrColorInfoListString = (String)request.getParameter("hdrColorInfo");

//System.out.println("dtColorInfoListString:" + dtColorInfoListString);
//System.out.println("hdrColorInfoListString:" + hdrColorInfoListString);

	  	Report report = (Report)request.getSession().getAttribute("report");

		// FNA
		report.clearColorList();

		// f[^e[u̐FReportIuWFNgɒǉ
		ArrayList dtColorInfoList = changeColorList(dtColorInfoListString, false);
		report.addColor(dtColorInfoList);

		// wb_̐FReportIuWFNgɒǉ
		ArrayList hdrColorInfoList = changeColorList(hdrColorInfoListString, true);
		report.addColor(hdrColorInfoList);

	}


	public void saveColor(Report report, Connection conn) throws SQLException {

		// ̐Fݒ͑Sč폜Ăinsert
		// delete
		this.deleteColor(report, conn);


		Iterator it = report.getColorList().iterator();
		while (it.hasNext()) {
			Color color = (Color) it.next();
			String edgeIdCombo = "";
			String[] edgeMemKey = new String[6];

			TreeMap axisIDAndMemberKeyTree = color.getAxisIDAndMemberKeyMap();
			Iterator keyIt = axisIDAndMemberKeyTree.keySet().iterator();
			int i = 0;
			while (keyIt.hasNext()) {
				if(i>0){
					edgeIdCombo += ",";
				}
				Integer key = (Integer) keyIt.next();
				edgeIdCombo += key.toString();
//System.out.println("key,value" + key + "," + axisHash.get(key));
				edgeMemKey[i] = (String)axisIDAndMemberKeyTree.get(key);
				i++;
			}

			Statement stmt = conn.createStatement();			
			try {
				// insert
				String SQL = "";
				SQL =  "";
				SQL += "INSERT INTO oo_v_color ";
				SQL += "       (report_id, edge_id_combo,";
				for (int j = 0; j < edgeMemKey.length; j++) {
					SQL +=            "edge_mem_key" + (j+1) +",";
				}
				SQL += "       headerflg, html_color) ";
				SQL += "values ( ";
				SQL +=                report.getReportID() + ", ";
				SQL +=          "'" + edgeIdCombo + "', ";
				
				for (int j = 0; j < edgeMemKey.length; j++) {
					SQL +=            edgeMemKey[j] + ", ";
				}
	
				SQL +=          "'" + CommonUtils.boolToFLG(color.isHeader()) + "', ";
				SQL +=          "'" + color.getHtmlColor() + "'"; 
	            SQL +=        ")";
//System.out.println("saveColor:" + SQL);
	
				int insertCount = stmt.executeUpdate(SQL);
				if (insertCount != 1) {
					throw new IllegalStateException();
				}

			} catch (IllegalStateException e) {
				throw e;
			} catch (SQLException e) {
				throw e;
			} catch (Exception e) { 
				e.printStackTrace();
			} finally {
				if (stmt != null) {
					stmt.close();
				}
			} 
		}
	}



	public void deleteColor(Report report, Connection conn) throws SQLException {

		String SQL = "";
		SQL =  "";
		SQL += "delete from oo_v_color ";
		SQL += "where ";
		SQL += "    report_id=" + report.getReportID();

		Statement stmt = conn.createStatement();
		try {
			stmt.executeUpdate(SQL);
		} catch (SQLException e) {
			throw e;
		} catch (Exception e) { 
			e.printStackTrace();
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		} 

	}

	// ********** private\bh **********

	// J[񕶎AJ[IuWFNgArrayList𐶐

	private ArrayList changeColorList(String sourceString, boolean isHeader) {

		ArrayList colorList = new ArrayList();	// ColorIuWFNg̃Xg
		Color color = null;

		// f[^e[uZ̐Fݒǉ
		ArrayList colorInfoList = StringUtil.splitString(sourceString, ",");	// uID.Key:EEE:ID.Key;colorvXg
		Iterator colorInfoIt = colorInfoList.iterator();


		int i = 0;		
		while (colorInfoIt.hasNext()) {
			TreeMap idKeyList = new TreeMap();	// ID(Key)ƎoKey(Value)

			String colorInfo = (String) colorInfoIt.next();						// uID.Key:EEE:ID.Key;colorv
			ArrayList comboKeyColorList = StringUtil.splitString(colorInfo,";");	// uID.Key:EEE:ID.Keyv,ucolorvXg

			String comboKeyListString = (String) comboKeyColorList.get(0);	// uID.Key:EEE:ID.Keyv
			String colorString = (String) comboKeyColorList.get(1);			// ucolorv

			ArrayList comboKeyList = StringUtil.splitString(comboKeyListString, ":");	// uID.KeyṽXg
			Iterator comboKeyIte = comboKeyList.iterator();

			while (comboKeyIte.hasNext()) {
				String comboKeyString = (String) comboKeyIte.next();
				
				ArrayList axisIDAndKey = StringUtil.splitString(comboKeyString, ".");
				
				idKeyList.put(Integer.decode((String)axisIDAndKey.get(0)), (String)axisIDAndKey.get(1));	// ID,o[L[

			}

			color = new Color( idKeyList, 			// axisIDAndMemberKeyMap 
							    isHeader, 			// isHeader
							    colorString);		// HTMLColor

			colorList.add(color);
			i++;
		}

//System.out.println("size:" + colorList.size());
//Iterator it = colorList.iterator();
//while (it.hasNext()) {
//	Color oColor = (Color) it.next();
//
//	TreeMap comboKeyHash = oColor.getAxisIDAndMemberKeyMap();
//	Iterator comboKeyIt = comboKeyHash.keySet().iterator();
//	while (comboKeyIt.hasNext()) {
//		String key = (String) comboKeyIt.next();
//		System.out.println("key,value:" + key + "," + comboKeyHash.get(key));
//	}
//	System.out.println("color:" + oColor.getHtmlColor());
//}

		return colorList;

	}

}
