/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresDAOFactory.java
 *  F
 *
 *  쐬: 2004/01/06
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import openolap.viewer.Axis;
import openolap.viewer.Dimension;
import openolap.viewer.Measure;
import openolap.viewer.common.Messages;

/**
 *  NXFPostgresDAOFactory
 *  F
 */
public class PostgresDAOFactory extends DAOFactory {

	// Connection PoolAConnection擾
	public Connection getConnection(){
		Connection conn = null;
		try {
			InitialContext initCtx = new InitialContext();
			DataSource ds = (DataSource)initCtx.lookup("java:comp/env/jdbc/WroxTC41"); //$NON-NLS-1$
			conn = ds.getConnection();
			conn = initialyzeConnection(conn);
		} catch (SQLException e) {
			e.printStackTrace();
		} catch (NamingException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return conn;
	}

	// connection ̏
	// (search path ݒ)
	private Connection initialyzeConnection(Connection conn) throws SQLException {
		Statement stmt = null;
		String SQL     = ""; //$NON-NLS-1$
		SQL =   ""; //$NON-NLS-1$
		SQL +=	"set search_path to " + Messages.getString("PostgresDAOFactory.meta") + ",public"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

		try {
			stmt = conn.createStatement();
			int retNum = stmt.executeUpdate(SQL);
		} catch (SQLException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
				}
			} catch (SQLException e) {
				throw e;
			}
		}
		return conn;
	}

	// DAO擾p\bh

	public DimensionDAO getDimensionDAO(Connection conn) {
		return new PostgresDimensionDAO(conn);
	}
	public MeasureDAO getMeasureDAO(Connection conn) {
		return new PostgresMeasureDAO(conn);
	}
	public MeasureMemberDAO getMeasureMemberDAO(Connection conn) {
		return new PostgresMeasureMemberDAO(conn);
	}
	public ReportDAO getReportDAO(Connection conn) {
		return new PostgresReportDAO(conn);
	}
	public CubeDAO getCubeDAO(Connection conn) {
		return new PostgresCubeDAO(conn);
	}
	public AxisLevelDAO getAxisLevelDAO(Connection conn) {
		return new PostgresAxisLevelDAO(conn);
	}
	public DimensionMemberDAO getDimensionMemberDAO(Connection conn) {
		return new PostgresDimensionMemberDAO(conn);
	}
	public CellDataDAO getCellDataDAO(Connection conn){
		return new PostgresCellDataDAO(conn);
	}
	public MeasureMemberTypeDAO getMeasureMemberTypeDAO(Connection conn) {
		return new PostgresMeasureMemberTypeDAO(conn);
	}
	public AxisDAO getAxisDAO(Connection conn) {
		return new PostgresAxisDAO(conn);
	}

	public AxisMemberDAO getAxisMemberDAO(Connection conn) {
		return new PostgresDimensionMemberDAO(conn);
	}
	public AxisMemberDAO getAxisMemberDAO(Connection conn, Axis axis) {
		if (axis == null) {
			return new PostgresDimensionMemberDAO(conn);
		} else if(axis instanceof Measure){
			return new PostgresMeasureMemberDAO(conn);
		} else if (axis instanceof Dimension){
			return new PostgresDimensionMemberDAO(conn);
		} else {
			throw new IllegalStateException();
		}
	}
	public ColorDAO getColorDAO(Connection conn){
		return new PostgresColorDAO(conn);
	}

	public UserDAO getUserDAO(Connection conn) {
		return new PostgresUserDAO(conn);
	}


}
