/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresMeasureMemberDAO.java
 *  F
 *
 *  쐬: 2004/01/07
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;

import openolap.viewer.Axis;
import openolap.viewer.Measure;
import openolap.viewer.MeasureMember;
import openolap.viewer.MeasureMemberType;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.CommonUtils;
import openolap.viewer.common.StringUtil;
import openolap.viewer.controller.RequestHelper;

/**
 *  NXFPostgresMeasureMemberDAO
 *  F
 */
public class PostgresMeasureMemberDAO extends PostgresAxisMemberDAO implements MeasureMemberDAO {

	Connection conn = null;

	PostgresMeasureMemberDAO(Connection conn) {
		this.conn = conn;
	}	

	public ArrayList selectMeasureMembers(String cubeSeq, CommonSettings commonSettings)  throws SQLException {

		// W[o擾
		ArrayList measureMemberList = new ArrayList();
		MeasureMember measureMem = null;
		String SQL = "";
		Statement stmt = null;
		ResultSet rs = null;

		SQL =   "";
		SQL +=	"select ";
		SQL +=	"    distinct c.measure_seq,m.name  ";
		SQL +=	"from ";
		SQL +=	"    oo_info_mes c,(select measure_seq,name from oo_measure union select formula_seq as measure_seq,name from oo_formula) m ";
		SQL +=	"where ";
		SQL +=	"c.cube_seq = " + cubeSeq + " and  ";
		SQL +=	"c.measure_seq=m.measure_seq ";
		SQL +=	"order by c.measure_seq ";
//System.out.println("SQL:" + SQL);

		try {
			stmt = conn.createStatement();
			rs   = stmt.executeQuery(SQL);

			int i=0;
			while ( rs.next() ) {
				measureMem = new MeasureMember(Integer.toString(i), 						// id
												rs.getString("name"), 						// measureName
												commonSettings.getFirstMeasureMemberType(), // measureMemberType
												Integer.toString(i+1), 						// uniqueName
												rs.getString("measure_seq"));				// measureSeq
//System.out.println("ID:" + Integer.toString(i) + "\nNAME:" + rs.getString("name") + "\nTYPE:" + commonSettings.getFirstMeasureMemberType().getName() );
				i++;
				measureMemberList.add(measureMem);
			}

		} catch (SQLException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		return measureMemberList;
	}

	public void applyAxis(Report report, Axis axis, CommonSettings commonSettings) throws SQLException {

		String SQL = null;
		ResultSet rs = null;
		Statement stmt = null;
		try {
			SQL = DAOFactory.getDAOFactory().getAxisMemberDAO(conn,axis).selectSaveDataSQL(report, axis);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(SQL);

//			axis.getAxisMemberByUniqueName(Integer.toString(i));

			Measure Mem = (Measure) axis;
			ArrayList measureMemList = axis.getAxisMemberList();

			int i = 0;
			while ( rs.next() ) {

				// ZNgꂽǂAW[o[^CvXV				
				MeasureMember measureMember = (MeasureMember)measureMemList.get(i);
				measureMember.setIsSelected(CommonUtils.FLGTobool(rs.getString("selectedFLG")));
				String measureMemberTypeID = rs.getString("measure_member_type_id");
				MeasureMemberType newMeasureMemberType = commonSettings.getMeasureMemberTypeByID(measureMemberTypeID);
				measureMember.setMeasureMemberType(newMeasureMemberType);				

				i++;			
			}

		} catch (SQLException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
		
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

	}

	public void registMeasureMemberType(RequestHelper helper, CommonSettings commonSettings) {

		HttpServletRequest request = helper.getRequest();
		String measureTypes = (String)request.getParameter("measureTypes");

		Report report = (Report)helper.getRequest().getSession().getAttribute("report");
	
		ArrayList measureMemberIDTypeIDPairList = StringUtil.splitString(measureTypes,",");
		Iterator it = measureMemberIDTypeIDPairList.iterator();
		while (it.hasNext()) {
			String measureMemberIDTypeIDPair = (String) it.next();
			ArrayList measureMemberIDTypeIDList = StringUtil.splitString(measureMemberIDTypeIDPair,":");

			String measureMemberID =(String)measureMemberIDTypeIDList.get(0);
			String measureMemberTypeID = (String) measureMemberIDTypeIDList.get(1);

			MeasureMember measureMember = (MeasureMember) report.getMeasure().getAxisMemberByUniqueName(measureMemberID);
			MeasureMemberType newMeasureMemberType = commonSettings.getMeasureMemberTypeByID(measureMemberTypeID);

			measureMember.setMeasureMemberType(newMeasureMemberType);

//System.out.println(measureMember.getMeasureMemberType().getName());
			
		}

	}

	public void saveAxisMember(Report report, Axis axis, Connection conn) throws SQLException {
		Measure measure = null;
		if (axis instanceof Measure) {
			measure = (Measure) axis;
		} else {
			throw new IllegalArgumentException();
		}

		String SQL = "";
		Statement stmt = conn.createStatement();

		try {
			Iterator meaIt = measure.getAxisMemberList().iterator();
			while (meaIt.hasNext()) {
				MeasureMember measureMember = (MeasureMember) meaIt.next();
				
				SQL =  "";
				SQL += "UPDATE oo_v_axis_member set";
				SQL += "    dimension_seq=" + measureMember.getMeasureSeq() + ", ";
				SQL += "    selectedFLG=" + CommonUtils.boolToFLG(measureMember.isSelected()) + ", ";
				SQL += "    measure_member_type_id=" + measureMember.getMeasureMemberType().getId();
				SQL += "WHERE ";
				SQL += "    report_id=" + report.getReportID() + " and ";
				SQL += "    axis_id=" + axis.getId() + " and ";
				SQL += "    member_key=" + measureMember.getUniqueName();
//System.out.println("update measure Member:" + SQL);
				int updateCount = stmt.executeUpdate(SQL);
	
				// update0̏ꍇAVɃR[h쐬
				if (updateCount == 0) {
					SQL = "";
					SQL += "INSERT INTO ";
					SQL += "    oo_v_axis_member ";
					SQL += "       (report_id, axis_id, dimension_seq, member_key, selectedflg, drilledflg, measure_member_type_id) ";
					SQL += "values ( ";
					SQL +=                report.getReportID() + ", ";			// report_id
					SQL +=                axis.getId() + ", ";					// axis_id
					SQL +=                measureMember.getMeasureSeq()	+ ", ";	// measure_seq
					SQL +=                measureMember.getUniqueName() + ", ";	// member_key
					SQL +=                "'" + CommonUtils.boolToFLG(measureMember.isSelected()) +  "', ";	// selectedFLG
					SQL +=                "'0', ";								// drilledFLG false(-)BW[͊KwȂׁAh邱ƂłȂ
					SQL +=                measureMember.getMeasureMemberType().getId();	// measureMemberType id
					SQL +=         ")";
//System.out.println("saveMeasureMember:" + SQL);
	
					int insertCount = stmt.executeUpdate(SQL);
					if (insertCount != 1) {
						throw new IllegalStateException();
					}
	
				}
			}
		} catch (IllegalStateException e) {
			throw e;
		} catch (SQLException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
					if (stmt != null) {
				stmt.close();
			}
		}
	}

}
