/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFReportDAO.java
 *  F
 *
 *  쐬: 2004/01/07
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.controller.RequestHelper;

/**
 *  C^[tF[XFReportDAO
 *  F
 */
public interface ReportDAO {

	public String getInitialReportID(Connection conn) throws SQLException;
	public void registAxisPosition(RequestHelper helper, CommonSettings commonSettings);
	public void registAxisPosition(ArrayList colItemList, ArrayList rowItemList, ArrayList pageItemList, Report report);
	public void saveReport(Report report, Connection conn) throws SQLException;
	public Report getInitialReport(String cubeSeq, CommonSettings commonSettings) throws SQLException;
	public Report getExistingReport(String reportId, CommonSettings commonSettings) throws SQLException;
	public void registReport(RequestHelper helper, CommonSettings commonSettings);

}
