/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.sql.SQLException;
import org.postgresql.core.Encoding;
import org.postgresql.util.PSQLException;

public class PG_Stream {
    private Socket connection;
    private InputStream pg_input;
    private BufferedOutputStream pg_output;
    private byte[] byte_buf = new byte[8192];

    public PG_Stream(String host, int port) throws IOException {
        this.connection = new Socket(host, port);
        this.connection.setTcpNoDelay(true);
        this.pg_input = new BufferedInputStream(this.connection.getInputStream(), 8192);
        this.pg_output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
    }

    public void SendChar(int val) throws IOException {
        this.pg_output.write((byte)val);
    }

    public void SendInteger(int val, int siz) throws IOException {
        byte[] buf = new byte[siz];
        while (siz-- > 0) {
            buf[siz] = (byte)(val & 0xFF);
            val >>= 8;
        }
        this.Send(buf);
    }

    public void Send(byte[] buf) throws IOException {
        this.pg_output.write(buf);
    }

    public void Send(byte[] buf, int siz) throws IOException {
        this.Send(buf, 0, siz);
    }

    public void Send(byte[] buf, int off, int siz) throws IOException {
        this.pg_output.write(buf, off, buf.length - off < siz ? buf.length - off : siz);
        if (buf.length - off < siz) {
            for (int i = buf.length - off; i < siz; ++i) {
                this.pg_output.write(0);
            }
        }
    }

    public int ReceiveChar() throws SQLException {
        int c = 0;
        try {
            c = this.pg_input.read();
            if (c < 0) {
                throw new PSQLException("postgresql.stream.eof");
            }
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.stream.ioerror", e);
        }
        return c;
    }

    public int ReceiveInteger(int siz) throws SQLException {
        int n = 0;
        try {
            for (int i = 0; i < siz; ++i) {
                int b = this.pg_input.read();
                if (b < 0) {
                    throw new PSQLException("postgresql.stream.eof");
                }
                n |= b << 8 * i;
            }
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.stream.ioerror", e);
        }
        return n;
    }

    public int ReceiveIntegerR(int siz) throws SQLException {
        int n = 0;
        try {
            for (int i = 0; i < siz; ++i) {
                int b = this.pg_input.read();
                if (b < 0) {
                    throw new PSQLException("postgresql.stream.eof");
                }
                n = b | n << 8;
            }
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.stream.ioerror", e);
        }
        return n;
    }

    public String ReceiveString(Encoding encoding) throws SQLException {
        int s = 0;
        byte[] rst = this.byte_buf;
        try {
            int buflen = rst.length;
            boolean done = false;
            block2: while (!done) {
                while (s < buflen) {
                    int c = this.pg_input.read();
                    if (c < 0) {
                        throw new PSQLException("postgresql.stream.eof");
                    }
                    if (c == 0) {
                        rst[s] = 0;
                        done = true;
                        continue block2;
                    }
                    rst[s++] = (byte)c;
                    if (s < buflen) continue;
                    byte[] newrst = new byte[buflen *= 2];
                    System.arraycopy(rst, 0, newrst, 0, s);
                    rst = newrst;
                }
            }
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.stream.ioerror", e);
        }
        return encoding.decode(rst, 0, s);
    }

    public byte[][] ReceiveTuple(int nf, boolean bin) throws SQLException {
        int bim = (nf + 7) / 8;
        byte[] bitmask = this.Receive(bim);
        byte[][] answer = new byte[nf][0];
        int whichbit = 128;
        int whichbyte = 0;
        for (int i = 0; i < nf; ++i) {
            boolean isNull;
            boolean bl = isNull = (bitmask[whichbyte] & whichbit) == 0;
            if ((whichbit >>= 1) == 0) {
                ++whichbyte;
                whichbit = 128;
            }
            if (isNull) {
                answer[i] = null;
                continue;
            }
            int len = this.ReceiveIntegerR(4);
            if (!bin) {
                len -= 4;
            }
            if (len < 0) {
                len = 0;
            }
            answer[i] = this.Receive(len);
        }
        return answer;
    }

    private byte[] Receive(int siz) throws SQLException {
        byte[] answer = new byte[siz];
        this.Receive(answer, 0, siz);
        return answer;
    }

    public void Receive(byte[] b, int off, int siz) throws SQLException {
        try {
            int w;
            for (int s = 0; s < siz; s += w) {
                w = this.pg_input.read(b, off + s, siz - s);
                if (w >= 0) continue;
                throw new PSQLException("postgresql.stream.eof");
            }
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.stream.ioerror", e);
        }
    }

    public void flush() throws SQLException {
        try {
            this.pg_output.flush();
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.stream.flush", e);
        }
    }

    public void close() throws IOException {
        this.pg_output.close();
        this.pg_input.close();
        this.connection.close();
    }
}

