/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFEdgeCoordinates.java
 *  F܂͍swb_̍W\IuWFNgłB
 *
 *  쐬: 2004/01/19
 */
package openolap.viewer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;

import openolap.viewer.common.StringUtil;

/**
 *  NXFEdgeCoordinates
 *  F܂͍swb_̍W\IuWFNgłB
 */
public class EdgeCoordinates implements Serializable {

	// ********** CX^Xϐ **********

	/** ܂͍s̃CfbNX(܂͍sɑ΂ĈӂɂȂ0start̒ʔ) */
	final private Integer index;

	/** ܂͍s̊ei̎IDKEYƂAo[̃L[VALUEɎMapIuWFNg */
	final private LinkedHashMap axisIdMemKeyMap;


	// ********** RXgN^ **********

	/**
	 * ܂͍swb_̍W\IuWFNg𐶐܂B
	 */
	public EdgeCoordinates(Integer index, LinkedHashMap axisIdMemKeyMap) {
		this.index = index;
		this.axisIdMemKeyMap = axisIdMemKeyMap;
	}

	// ********** Static \bh **********

	/**
	 * ܂͍swb_̍W\IuWFNg̃Xg߂
	 * @param indexKey ܂͍sňӂɒ܂SpreadIndexƁAeĩo[L[̑gݍ킹̃Xg<br>
	 *        F<index>:<1iڂkey>;<2iڂkey>;<3iڂkey>,<index>:<1iڂkey>;<2iڂkey>;<3iڂkey>,<br>
	 *        s܂͗񂪂RȉꍇYkeỷӏ͋󕶎
	 * @param axisIdList s܂͗ɔzuꂽID̔ziя̓GbW̔zuj
	 * @return ܂͍swb_̍W\IuWFNg̃Xg
	 */
	public static ArrayList createCoordinates(String indexKey, String[] axisIdList) {

		ArrayList axisCoordinatesList = new ArrayList();	// WXg
		EdgeCoordinates axisCoordinates = null;				// W

		Iterator axisIt = StringUtil.splitString(indexKey,",").iterator();
		while (axisIt.hasNext()) {
			LinkedHashMap axisIdKeyMap = new LinkedHashMap();

			String indexKeysString = (String) axisIt.next();
			ArrayList indexKeysList = StringUtil.splitString(indexKeysString,":");
			Integer axisIndex = Integer.decode((String) indexKeysList.get(0));		// ̃CfbNX
			String colKeys = (String) indexKeysList.get(1);							// ̃L[̑gݍ킹()
			ArrayList axisKeyList = StringUtil.splitString(colKeys,";");			// ̃L[̑gݍ킹(z)

			Iterator keyListIte = axisKeyList.iterator();
			int j = 0;
			while (keyListIte.hasNext()){
				String key = (String) keyListIte.next();
				axisIdKeyMap.put(Integer.decode(axisIdList[j]), key);
				j++;
			}
			axisCoordinatesList.add(new EdgeCoordinates(axisIndex, axisIdKeyMap));
		}

		return axisCoordinatesList;
	}

	// ********** Getter \bh **********

	/**
	 * ܂͍s̃CfbNX߂B
	 * (܂͍sɑ΂ĈӂɂȂ0start̒ʔ) 
	 * @return ܂͍s̃CfbNX
	 */
	public Integer getIndex() {
		return index;
	}

	/**
	 * ܂͍s̊ei̎IDKEYƂAo[̃L[VALUEɎMapIuWFNg߂B
	 * @return ܂͍s̊ei̎IDKEYƂAo[̃L[VALUEɎMapIuWFNg
	 */
	public LinkedHashMap getAxisIdMemKeyMap() {
		return axisIdMemKeyMap;
	}
}
