/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresDimensionMemberDAO.java
 *  FfBVo[IuWFNg̉iǗNXłB
 *
 *  쐬: 2004/01/09
 */
package openolap.viewer.dao;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import openolap.viewer.Axis;
import openolap.viewer.Dimension;
import openolap.viewer.DimensionMember;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
//import openolap.viewer.common.CommonUtils;
import openolap.viewer.common.StringUtil;

/**
 *  NXFPostgresDimensionMemberDAO
 *  FfBVo[IuWFNg̉iǗNXłB
 */
public class PostgresDimensionMemberDAO extends PostgresAxisMemberDAO implements DimensionMemberDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	private Connection conn = null;

	// ********** RXgN^ **********

	/**
	 *  fBVo[IuWFNg̉iǗIuWFNg𐶐܂B
	 */
	PostgresDimensionMemberDAO(Connection conn) {
		this.conn = conn;
	}

	// ********** \bh **********

	/**
	 * |[gS̃oID̏ŏo
	 * @param report |[gIuWFNg
	 * @param out PrintWriterIuWFNg
	 * @exception SQLException ɗO
	 */
	public void outputDimensionMemberAsXML(Report report, PrintWriter out) throws SQLException {

		ArrayList axisList = report.getAxilOrderByID();
		Iterator axisIt = axisList.iterator();

		while (axisIt.hasNext()) {
			Axis axis = (Axis) axisIt.next();
			outputDimensionMemberAsXML(report, axis, true, out); // ̃oo
		}
	}


	/**
	 * w肳ꂽ̃oo
	 * @param report |[gIuWFNg
	 * @param axis IuWFNg
	 * @param selectFLG ̃o[i荞܂Ă邩ǂ킷tO
	 * @param out PrintWriterIuWFNg
	 * @exception SQLException ɗO
	 */
	public void outputDimensionMemberAsXML(Report report, Axis axis, boolean selectFLG, PrintWriter out) throws SQLException {

		if (axis instanceof Dimension) {
			Dimension dim = (Dimension) axis;
			out.println("<Members name=\"" + dim.getName() + "\" id=\"" + dim.getId() +  "\">");

			// ZN^ɂi݁Ahݒ𔽉f
			HashMap memKeyDrill = null;
			String  selectedKeyString = null;
			if (selectFLG) {
				if (dim.getSelectedMemberDrillStat().size() > 0) { // h񂪑݂Ȃ΁A擾
					memKeyDrill = dim.getSelectedMemberDrillStat();
				}

				// fBVoXgSQLŎ擾ۂ̃ZN^ɂiݏ擾
				if(axis.isUsedSelecter()) {
					Iterator it = memKeyDrill.keySet().iterator();
					int i = 0;
					selectedKeyString = "',";
					while (it.hasNext()) {
						String key = (String) it.next();
						if(i > 0) {
							selectedKeyString += ",";
						}
						selectedKeyString += key;
						i++;
					}
					selectedKeyString += ",'";
				}
			}

			Statement stmt = null;
			ResultSet rs   = null;
			try {
				stmt = conn.createStatement();
				String SQL = this.makeSQL(dim,selectedKeyString);
//System.out.println("writeDimensionMemberAsXML:" + SQL);
				rs   = stmt.executeQuery(SQL);

				writeDimensionMemberAsXML(rs, out, memKeyDrill);

			} catch (SQLException e) {
				throw e;
			} catch (IOException e) {
				e.printStackTrace();
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				try {
					if (rs != null){
						rs.close();
					}
				} catch (SQLException e) {
					throw e;
				} finally {
					try {
						if (stmt != null){
							stmt.close();
						}
					} catch (SQLException e) {
						throw e;
					}
				}
			}
			out.println("</Members>");
		}
		
	}

	/**
	 * w肳ꂽfBṼo[IuWFNg̃Xg߂B
	 * @param dim fBVIuWFNg
	 * @param shortNameCondition V[gl[ɂ擾
	 * @param longNameCondition Ol[ɂ擾
	 * @param levelCondition xɂ擾
	 * @param selectedKeyString 擾ΏۂƂ郁o[L[̃Xg킷
	 * @return fBVo[IuWFNg̃Xg
	 * @exception SQLException ɗO
	 */
	public ArrayList selectDimensionMembers(Dimension dim, String shortNameCondition, String longNameCondition, String levelCondition, String selectedKeyString) throws SQLException {
		ArrayList dimensionMemberList = new ArrayList();

		DimensionMember dimensionMember = null;
		
		Statement stmt = null;
		ResultSet rs   = null;
		try {
			stmt = conn.createStatement();
//System.out.println("Select SQL:\n" + makeSQL(dim,selectedKeyString,shortNameCondition,longNameCondition,levelCondition));
			rs   = stmt.executeQuery(this.makeSQL(dim,selectedKeyString,shortNameCondition,longNameCondition,levelCondition));
			int i = 0;
			while (rs.next()) {

				boolean leafFLG = false;
				if ( rs.getString("leaf_flg") != null ) {
					if ( rs.getString("leaf_flg").equals("1") ) {
						leafFLG = true;
					} else {
						leafFLG = false;
					}
				} else {
					leafFLG = false;
				}

				dimensionMember = new DimensionMember( Integer.toString(i),				// id
														Integer.toString(rs.getInt("key")),	// uniqueName
														rs.getString("code"),				// code
														rs.getString("short_name"),			// short_name
														rs.getString("long_name"),			// long_name
														rs.getString("indented_short_name"),// indented_short_name
														rs.getString("indented_long_name"), // indented_long_name
														rs.getInt("level"),					// level
														leafFLG								// isLeaf
														);	

				dimensionMemberList.add(dimensionMember);
				i++;
			}

		} catch (SQLException e) {
			throw e;
		} catch (Exception e) { 
			e.printStackTrace();
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}
		
		return dimensionMemberList;
	}


	/**
	 * w肳ꂽfBṼo[IuWFNgXg̐擪̃o[IuWFNg߂B
	 * @param dim fBVIuWFNg
	 * @return fBVo[IuWFNg
	 * @exception SQLException ɗO
	 */
	public DimensionMember getFirstMember(Dimension dim) throws SQLException {

		DimensionMember dimensionMember = null;
		
		Statement stmt = null;
		ResultSet rs   = null;
		try {
			stmt = conn.createStatement();

			
			rs   = stmt.executeQuery(this.makeSQL(dim,null) + " offset 0 limit 1 ");
			int i = 0;
			while (rs.next()) {

				boolean leafFLG = false;
				if ( rs.getString("leaf_flg") != null ) {
					if ( rs.getString("leaf_flg").equals("1") ) {
						leafFLG = true;
					} else {
						leafFLG = false;
					}
				} else {
					leafFLG = false;
				}

				dimensionMember = new DimensionMember( Integer.toString(i),				// id
														Integer.toString(rs.getInt("key")),	// uniqueName
														rs.getString("code"),				// code
														rs.getString("short_name"),			// short_name
														rs.getString("long_name"),			// long_name
														rs.getString("indented_short_name"),// indented_short_name
														rs.getString("indented_long_name"), // indented_long_name
														rs.getInt("level"),					// level
														leafFLG								// isLeaf
														);	

				i++;
			}
			if (i != 1) {	// 擾ʂ0ȊȌꍇAG[
				throw new IllegalStateException();
			}

		} catch (SQLException e) {
			throw e;
		} catch (Exception e) { 
			e.printStackTrace();
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		return dimensionMember;

	}



	/**
	 * fBVIuWFNg̃o[\^CvAXML̃^OɕϊB
	 * @param modelString o[\^Cv킷
	 * @return XML̃^O
	 */
	public String transferMemberDisplayTypeFromModelToXML(String modelString){
		if (Dimension.DISP_SHORT_NAME.equals(modelString)){
			return "Caption";
		} else if (Dimension.DISP_LONG_NAME.equals(modelString)) {
			return "Caption2";
		} else {
			throw new IllegalArgumentException();
		}
	}

	/**
	 * fBVo[f[^\[X̏ƂɐAfBVIuWFNg"selectedMemberDrillStat"ɐݒ肷B
	 * @param report |[gIuWFNg
	 * @param axis IuWFNg
	 * @param commonSettings AvP[V̋ʐݒ킷IuWFNg
	 * @exception SQLException ɗO
	 */
	public void applyAxis(Report report, Axis axis, CommonSettings commonSettings) throws SQLException {

		String SQL = null;
		ResultSet rs = null;
		Statement stmt = null;
		try {
			SQL = DAOFactory.getDAOFactory().getAxisMemberDAO(null,axis).selectSaveDataSQL(report, axis);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(SQL);

			Dimension dim = (Dimension) axis;


// fBV̓fBVoIuWFNgێȂ(SessionɕێIuWFNg̐ߖ̂)Rg
//
//
//			String selectedKeyString = "',";
//			ArrayList drilledFLGList = new ArrayList();
			HashMap selectedMemKeyDrillStat = new HashMap();
//			int i = 0;
			while ( rs.next() ) {
//				if(i>0) {
//					selectedKeyString += ",";
//				}
//				selectedKeyString += rs.getString("member_key");
//				drilledFLGList.add(rs.getString("drilledFLG"));
				selectedMemKeyDrillStat.put(rs.getString("member_key"),rs.getString("drilledFLG"));
//				i++;			
			}
//			selectedKeyString += ",'";

			// fBVo擾
//			ArrayList dimensionMemList = selectDimensionMembers(dim,				// fBV
//																null,				// (short_name)
//																null,				// (long_name)
//																null,				// (level)
//																selectedKeyString);	// (ΏۃõL[Xg)


			// h␳
//			Iterator it = dimensionMemList.iterator();
//			int j = 0;
//			while (it.hasNext()) {
//				DimensionMember dimensionMember = (DimensionMember) it.next();
//				dimensionMember.setDrilled(CommonUtils.FLGTobool((String)drilledFLGList.get(j)));
//				j++;
//			}

			// fBVofBVɓo^
			if(selectedMemKeyDrillStat.size()>0){
				dim.setSelectedMemberDrillStat(selectedMemKeyDrillStat);
			}


		} catch (SQLException e) {
			throw e;
		} catch (Exception e) { 
			e.printStackTrace();
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

	}

	/**
	 * ^ꂽ̃fBVo[iB
	 * @param report |[gIuWFNg
	 * @param axis IuWFNg
	 * @param conn ConnecionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void saveAxisMember(Report report, Axis axis, Connection conn) throws SQLException {
		Dimension dim = null;
		if (axis instanceof Dimension) {
			dim = (Dimension) axis;
		} else {
			throw new IllegalArgumentException();
		}

		// fBVɑ΂ZN^ōi݂sꂽꍇAIꂽô݂ێ邽߁A
		// deleteAinserts

		// delete
		this.deleteAxisMember(report, axis, conn);

		HashMap selectedMemberDrillStat = dim.getSelectedMemberDrillStat();
			if ( selectedMemberDrillStat.size() == 0 ) {	// ʂ0
				return;
			}
		Iterator keyIt = selectedMemberDrillStat.keySet().iterator();

		// insert
		String SQL = "";
		Statement stmt = conn.createStatement();
		try {
			while (keyIt.hasNext()) {
				String uName = (String) keyIt.next();
				
				SQL = "";
				SQL += "INSERT INTO ";
				SQL += "    oo_v_axis_member ";
				SQL += "       (report_id, axis_id, dimension_seq, member_key, selectedflg, drilledflg, measure_member_type_id) ";
				SQL += "values ( ";
				SQL +=                report.getReportID() + ", ";			// report_id
				SQL +=                axis.getId() + ", ";					// axis_id
				SQL +=                dim.getDimensionSeq() + ", ";			// dimension_seq
				SQL +=                uName + ", ";							// member_key
				SQL +=                "'1', ";								// selectedFLG ZN^őIꂽô݂HashMapɎ߁A1(true)
				SQL +=          "'" + (String)selectedMemberDrillStat.get(uName)+ "', ";	// drilledFLG
				SQL +=                "null ";								// measure_member_type_id W[p̐ݒ̂߁AnullB
				SQL +=         ")";
//System.out.println("saveDimensionMember:" + SQL);
	
				int insertCount = stmt.executeUpdate(SQL);
				if (insertCount != 1) {
					throw new IllegalStateException();
				}
			}
		} catch (IllegalStateException e) {
			throw e;	
		} catch (SQLException e) {
			throw e;
		} catch (Exception e) { 
			e.printStackTrace();
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		}
	}

	/**
	 * ^ꂽfBVo[߂B
	 * @param dim fBVIuWFNg
	 * @return o[
	 * @exception SQLException ɗO
	 */
	public int getDimensionMemberNumber(Dimension dim) throws SQLException {
		
		DimensionDAO dimensionDAO = DAOFactory.getDAOFactory().getDimensionDAO(null);

		String SQL = null;
		SQL =   "";
		SQL +=	"SELECT ";
		SQL +=	"    count(*) as dimNumber ";
		SQL +=	"FROM ";
		SQL +=	"    oo_dim_tree('" + dimensionDAO.getDimensionTableName(dim.getDimensionSeq(),dim.getPartSeq()) + "',null,null) ";
		SQL +=  "WHERE leaf_flg != '9' ";	// ([Abv)ł̂ݎgp郁oɁu9vUĂ		

		Statement stmt = null;
		ResultSet rs = null;

		int dimNumber = 0;
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(SQL);
			while ( rs.next() ) {
				dimNumber = rs.getInt("dimNumber");	
			}

		} catch (SQLException e) {
			throw e;
		} catch (Exception e) { 
			e.printStackTrace();
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		return dimNumber;
	}

	// ********** private \bh **********

	/**
	 * o擾SQLijԂB
	 * @param dim fBVIuWFNg
	 * @param selectedKeyString 擾ΏۂƂ郁o[L[̃Xg킷
	 * @return SQL킷
	 */
	private String makeSQL(Dimension dim, String selectedKeyString) {

		DAOFactory daoFactory = DAOFactory.getDAOFactory();
		DimensionDAO dimensionDAO = daoFactory.getDimensionDAO(null);

		String SQL = null;
		SQL =   "";
		SQL +=	"SELECT ";
		SQL +=	"    key as key, ";
		SQL +=	"    level, ";
		SQL +=	"    leaf_flg, ";
		SQL +=	"    code, ";
		SQL +=	"    short_name, ";
		SQL +=	"    long_name, ";
		SQL +=	"    lpad('',level,'@') || short_name as indented_short_name, ";
		SQL +=	"    lpad('',level,'@') || long_name as indented_long_name ";
		SQL +=	"FROM ";
		SQL +=	"    oo_dim_tree('" + dimensionDAO.getDimensionTableName(dim.getDimensionSeq(),dim.getPartSeq()) + "',null," + selectedKeyString +") ";
		SQL +=  "WHERE leaf_flg != '9' ";	// ([Abv)ł̂ݎgp郁oɁu9vUĂ
//System.out.println("selectedKeyString:" + selectedKeyString);
		return SQL;
	}


	/**
	 * o擾SQLijԂB
	 * @param dim fBVIuWFNg
	 * @param selectedKeyString 擾ΏۂƂ郁o[L[̃Xg킷
	 * @param shortNameCondition fBVoshort_name
	 * @param longNameCondition fBVolong_name
	 * @param level fBṼx
	 * @return SQL킷
	 */
	private String makeSQL(Dimension dim, String selectedKeyString, String shortNameCondition, String longNameCondition, String levelCondition) {
		String SQL = makeSQL(dim,selectedKeyString);
		if( (shortNameCondition != null) && (!shortNameCondition.equals("")) ) {
			SQL += "    and short_name like '" + StringUtil.changeKomeToPercent(shortNameCondition) + "'";
		}
		if( (longNameCondition != null) && (!longNameCondition.equals("")) ) {
			SQL += "    and long_name like '" + StringUtil.changeKomeToPercent(longNameCondition) + "'";
		}
		if( (levelCondition != null) && (!levelCondition.equals("")) ) {
			SQL += "    and level like '" + StringUtil.changeKomeToPercent(levelCondition) + "'";
		}


		return SQL;
	}

	/**
	 * fBVo[XML`ŏo͂B
	 * @param rs fBVo[̌
	 * @param out PrintWriterIuWFNg
	 * @param memKeyDrill h
	 */
	private void writeDimensionMemberAsXML(ResultSet rs, PrintWriter out, HashMap memKeyDrill) 
											 throws SQLException, IOException {
		int    beforeLevel     = -1;       	// ÕR[h
		String isDrilledString  = "false";  	// ̃R[hDrill̒l

		int currentLevel = -1;  // ̃R[h̃x
		int j = 0;              // while[ṽJE^
		int k = 0;              // JE^

//System.out.println("memKeyDrill:" + memKeyDrill);

		while (rs.next()) {

			currentLevel = rs.getInt("level");

			// htO̐ݒ
			if ( memKeyDrill == null ) {
				// \̏ꍇiZbVɖo^jAftHg̓WJԂKp
				if ( rs.getString("leaf_flg") != null ) {
					if ( ( currentLevel == 1 ) && ( rs.getString("leaf_flg").equals("0") ) ) {
						isDrilledString = "true";
					} else {
						isDrilledString = "false";
					}
				} else {
					isDrilledString = "false";
				}
			} else {
				// DBɕۑꂽfBVo̓WJԂKp
				String tmpMemKey = Integer.toString(rs.getInt("key"));
				String drillStat = (String)memKeyDrill.get(tmpMemKey);

// System.out.println("tmpMemKey,drillStat" + tmpMemKey + "," + drillStat);

				if ( drillStat == null ) {				// |[gۑɂ݂͑Ȃo
					isDrilledString = "false";					
				} else if ( drillStat.equals("1") ) {
					isDrilledString = "true";
				} else {
					isDrilledString = "false";
				}

			}

			// Õ[v̗vf^O𐶐
			if ( j != 0 ) {
				if ( beforeLevel < currentLevel ) {			// O̗vf[
					// ^O͐Ȃ
				} else if ( beforeLevel > currentLevel ) {	// O̗vf
					// ^O𐶐
					for ( k=0; k < (beforeLevel - currentLevel + 1); k++ ) {
						out.println("</Member>");
					}
				} else if ( beforeLevel == currentLevel ) {	// O̗vfƓ
					// ^O𐶐
					out.println("</Member>");
				}
			}

			String leafString = "";
			if ( rs.getString("leaf_flg") != null ) {
				if ( rs.getString("leaf_flg").equals("1") ) {
					leafString = "true";
				} else {
					leafString = "false";
				}
			} else {
				leafString = "false";
			}

			out.println( "<Member id=\"" + j + "\">" );
			out.println( "    <UName>" + rs.getInt("key") + "</UName>" );
			out.println( "    <Code>" + rs.getString("code") + "</Code>");
			out.println( "    <Caption>" + rs.getString("short_name") + "</Caption>" );
			out.println( "    <Caption2>" + rs.getString("long_name") + "</Caption2>" );
			out.println( "    <LNum>" + rs.getInt("level") + "</LNum>" );
			out.println( "    <isDrilled>" + isDrilledString + "</isDrilled>" );
			out.println( "    <isLeaf>" + leafString + "</isLeaf>" );

			j++;
			beforeLevel = currentLevel;
		}

		// Ō̃o̕^O𐶐
		for ( k=0; k < beforeLevel; k++ ) {
			out.println("</Member>");
		}
	}
}
