/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */

package com.ibm.trl.tcg.pts.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibm.trl.tcg.pts.tools.Base64Tool;
import com.ibm.trl.tcg.pts.tools.DigestTool;
import com.ibm.trl.tcg.pts.tools.HexTool;

/**
 * @author Seiji Munetoh
 * 
 */
public class Event {

	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());

	// BIOS
	private long pcrIndex;

	private long eventType;

	private byte[] digest;

	private byte[] eventData;

	// PC Platform (eventType==6)
	private long pcEventID;

	private long pcEventDataSize;

	private byte[] pcEventData;

	// TSS

	// VS
	public long vsStatus = PlatformProperty.UNVERIFIED; // 0: net yet, 1: good,
														// 2

	// VALID = 0;
	// INVALID = 1;
	// UNVERIFIED = 2;,

	// Transition by
	public static final long DIGEST = 0;

	public static final long EVENTTYPE = 1;

	public long guardType = 0;

	// Digest Value 0
	// Event Type 1
	private boolean _printBase64;

	/* For Event Validation */

	private boolean _enableValidation = false;

	private boolean _integrity = true;

	private String _message;

	private String _str;

	// private boolean _hold = false;

	/**
	 * 
	 * ASCII string of eventlog like BIOS ASCII Eventlog format and also check
	 * the inetgrity of event.
	 * 
	 * TODO not a good method name.... sorry
	 * 
	 * Reference P76, Table 11
	 * 
	 */
	
	public String toString() {
		/*
		 * 6 d9be6524a5f5047db5866813acf3277892a7a30a 04 7
		 * d9be6524a5f5047db5866813acf3277892a7a30a 04 4
		 * 38f30a0a967fcf2bfee1e3b2971de540115048c8 05 [Returned INT 19h] 4
		 * 89f0284e00992d067654818a9f2c09bbaa31acde 05 [Booting CD ROM, -
		 * MATSHITADVD-RAM UJ-833S] 4 8dfd8ee51758ac29ccf1bb6eedc2d483acf83a9b
		 * 0d [IPL] 4 1cdac212c5342627905cfcc4931972a8b4a09996 0d [IPL] 4
		 * 2cedbf54913d69d027c5b97e02763f921b16e345 06
		 */
		boolean validateEventdata = false;
		String str = "";
		_message = "";

		/* PCR index */
		str = " " + pcrIndex + " ";

		/* Digest */
		if (_printBase64) {
			str += getBase64String(digest) + " ";

		} else {
			str += getHexString(digest) + " ";
		}

		/* Event Type (hex) */
		str += Integer.toString((int) eventType, 16) + " ";

		/* Event */
		str += "[";

		/* Event of IMA */
		if (pcrIndex == 10) { // IMA
			if (eventType == 0x00) {
				str += "IMA Boot Aggrigate";
			} else if ((eventType & 0x00ff) == 0x01) { // MASK for user measumrent
				str += "ELF";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
			} else if ((eventType & 0x00ff) == 0x02) {
				str += "LKM";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
			} else {
				str += "unknown";
			}

		}
		/* Event of BIOS and Grub */
		else {
			if (eventType == 0x01) {
				str += "EV_POST_CODE";
			} else if (eventType == 0x02) {
				str += "EV_UNUSED";
			} else if (eventType == 0x04) {
				str += "EV_SEPARATOR";
				if (eventData.length > 4) {
					str += "=\"" + new String(eventData) + "\"";
				} else {
					str += "[" + eventData.length + "]";
				}

				validateEventdata = true; // Check eventdata & digest later
			}
			// else if ( (0x0F & eventType) == 5) {
			else if ((eventType) == 5) {
				str += "EV_ACTION";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";

				validateEventdata = true; // Check eventdata & digest later
			} else if (eventType == 0x06) {
				str += "EV_EVENT_TAG";
				// byte[] tagEventData = getTagEventData(eventData);
				// int EventID = getDD(eventData,0);
				// int EventDataSize = getDD(eventData,4);
				// str += " ID=" + getHexString(eventData,0,4);
				// str += ",Size=" + getHexString(eventData,4,4);
				if (pcEventID == 0x01) {
					str += " SMBIOS[" + pcEventDataSize + "]";
					// log.debug("SMBIOS " + pcEventDataSize);
					// TODO
					// HexTool.printHex(eventData);
					// SMBIOS smbios = new SMBIOS(pcEventData);
					// smbios.print();
				} else if (pcEventID == 0x02) {
					str += " BIS Cert[" + pcEventDataSize + "]";
				} else if (pcEventID == 0x03) {
					str += " POST BIOS ROM Strings[" + pcEventDataSize + "]=";
					// str += "[" +new String(tagEventData) +"]";
					str += "\"" + getHexString(pcEventData) + "\"";
				} else if (pcEventID == 0x04) {
					str += " ESCD[" + pcEventDataSize + "]";
				} else if (pcEventID == 0x05) {
					str += " CMOS[" + pcEventDataSize + "]";
				} else if (pcEventID == 0x06) {
					str += " NVRAM[" + pcEventDataSize + "]";
				} else if (pcEventID == 0x07) {
					str += " Option ROM Execute[" + pcEventDataSize + "]";
					str += "\"" + getHexString(pcEventData) + "\"";
				} else if (pcEventID == 0x08) {
					str += " Option ROM Configuration[" + pcEventDataSize + "]";
				} else {
					str += " unknown " + pcEventID + "[" + pcEventDataSize
							+ "]";
				}
			} else if (eventType == 0x07) {
				// DELL BIOS use 7 for CRTM
				// EV_S_CRTM_CONTENTS
				str += "EV_S_CRTM_CONTENTS";

			} else if (eventType == 0x08) {
				str += "EV_S_CRTM_VERSION";
				if (eventData.length == 8) { // Panasonic use String
					str += "[8]=\"" + new String(eventData) + "\"";
				} else if (eventData.length == 5) { // Lenovo
					str += "[5]=\"" + new String(eventData) + "\"";
				} else { // 32 HP use hex
					str += "[" + eventData.length + "]=";
					str += getHexString(eventData) + "";
				}
			} else if (eventType == 0x09) {
				str += "EV_CPU_MICROCODE";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
			} else if (eventType == 0x0a) {
				str += "EV_PLATFORM_CONFIG_FLAGS";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\""; // Panasonic

				// TODO digest is not match. check the spec
				// validateEventdata = true; // Check eventdata & digest later
				_message += " TBD";
			} else if (eventType == 0x0c) {
				// DELL BIOS use 0xc for MBR?
				// EV_COMPACT_HASH
				str += "EV_COMPACT_HASH";

			} else if (eventType == 0x0d) {
				str += "EV_IPL";
				str += "[" + eventData.length + "]";
			} else if (eventType == 0x0e) {
				str += "EV_IPL_PARTITION_DATA";
				str += "[" + eventData.length + "]";
			} else if (eventType == 0x11) {
				str += "EV_NOHOST_INFO";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
				// str += "[" + getHexString(eventData) +"]";
			} else if (eventType == 0x12) {
				str += "EV_SPECIFICATION_IDENTIFIER";
				str += "[" + eventData.length + "]";
				str += "\"" + getHexString(eventData) + "\""; // Panasonic
				// 0000 00 00 01 01 01 02 01 64 00000000000

				validateEventdata = true; // Check eventdata & digest later
			}
			/* Grub */
			else if (eventType == 0x1005) {
				str += "EV_GRUB_BOOT_MSG";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";

				validateEventdata = true; // Check eventdata & digest later
			} else if (eventType == 0x1105) {
				str += "EV_GRUB_KERNEL_CMD";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";

				validateEventdata = true; // Check eventdata & digest later

			} else if (eventType == 0x1205) {
				str += "EV_GRUB_KERNEL";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
			} else if (eventType == 0x1305) {
				str += "EV_GRUB_INITRD";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
			} else if (eventType == 0x1405) {
				str += "EV_GRUB_MODULE";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
			} else if (eventType == 0x1505) {
				str += "EV_GRUB_MODULE_CMD";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";

				validateEventdata = true; // Check eventdata & digest later
			} else {
				if (eventData != null)
					str += "unknown[" + eventData.length + "]";
				else
					str += "unknown[null]";
			}
		}
		str += "]";

		if ((validateEventdata == true) && (_enableValidation == true)) {
			// if ((validateEventdata)) {
			/* Check Digest */
			byte[] d = DigestTool.SHA1(eventData);
			if (validateDigest(d, digest)) {
				// OK
				_message += " Good eventdata";
				if (log.isDebugEnabled()) {
					log.debug("Valid Evant Data");
					log.debug(" EventData(hex) : "
							+ HexTool.getHexString(eventData));
					log.debug(" Digest(hex)    : "
							+ HexTool.getHexString(digest));
				}
			} else {
				// NG
				if (eventType == 0x04) {
					_message += " BAD eventdata";
					log
							.error("Invalid Evant Data, but ignore type=0x04, workaround of XEN TCGBIOS");
				} else {
					_message += " BAD eventdata";
					_integrity = false;
				}
				if (log.isDebugEnabled()) {
					log.debug("Invalid Evant Data");
					log.debug(" EventData(hex) : "
							+ HexTool.getHexString(eventData));
					log.debug(" Digest(hex)    : "
							+ HexTool.getHexString(digest));
				}
			}
		} else {
			_message += "";
		}

		return str;
	}

	/**
	 * 
	 * TODO embedded into toSyring
	 * 
	 * 
	 * @return
	 */
	public String getEventDataString() {
		boolean validateEventdata = false;
		String str = "";
		_message = "";

		/* Event */
		str += "";

		/* Event of IMA */
		if (pcrIndex == 10) { // IMA
			if (eventType == 0x00) {
				str += "IMA Boot Aggrigate";
			} else if ((eventType & 0x00ff) == 0x01) {
				str += "ELF";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
			} else if ((eventType & 0x00ff) == 0x02) {
				str += "LKM";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
			} else {
				str += "unknown";
			}

		}
		/* Event of BIOS and Grub */
		else {
			if (eventType == 0x01) {
				str += "EV_POST_CODE";
			} else if (eventType == 0x02) {
				str += "EV_UNUSED";
			} else if (eventType == 0x04) {
				str += "EV_SEPARATOR";
				if (eventData.length > 4) {
					str += "=\"" + new String(eventData) + "\"";
				} else {
					str += "[" + eventData.length + "]";
				}

				validateEventdata = true; // Check eventdata & digest later
			}
			// else if ( (0x0F & eventType) == 5) {
			else if ((eventType) == 5) {
				str += "EV_ACTION";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";

				validateEventdata = true; // Check eventdata & digest later
			} else if (eventType == 0x06) {
				str += "EV_EVENT_TAG";
				// byte[] tagEventData = getTagEventData(eventData);
				// int EventID = getDD(eventData,0);
				// int EventDataSize = getDD(eventData,4);
				// str += " ID=" + getHexString(eventData,0,4);
				// str += ",Size=" + getHexString(eventData,4,4);
				if (pcEventID == 0x01) {
					str += " SMBIOS[" + pcEventDataSize + "]";
					// log.debug("SMBIOS " + pcEventDataSize);
					// TODO
					// HexTool.printHex(eventData);
					// SMBIOS smbios = new SMBIOS(pcEventData);
					// smbios.print();
				} else if (pcEventID == 0x02) {
					str += " BIS Cert[" + pcEventDataSize + "]";
				} else if (pcEventID == 0x03) {
					str += " POST BIOS ROM Strings[" + pcEventDataSize + "]=";
					// str += "[" +new String(tagEventData) +"]";
					str += "\"" + getHexString(pcEventData) + "\"";
				} else if (pcEventID == 0x04) {
					str += " ESCD[" + pcEventDataSize + "]";
				} else if (pcEventID == 0x05) {
					str += " CMOS[" + pcEventDataSize + "]";
				} else if (pcEventID == 0x06) {
					str += " NVRAM[" + pcEventDataSize + "]";
				} else if (pcEventID == 0x07) {
					str += " Option ROM Execute[" + pcEventDataSize + "]";
					str += "\"" + getHexString(pcEventData) + "\"";
				} else if (pcEventID == 0x08) {
					str += " Option ROM Configuration[" + pcEventDataSize + "]";
				} else {
					str += " unknown " + pcEventID + "[" + pcEventDataSize
							+ "]";
				}
			} else if (eventType == 0x07) {
				// DELL BIOS use 7 for CRTM
				// EV_S_CRTM_CONTENTS
				str += "EV_S_CRTM_CONTENTS";

			} else if (eventType == 0x08) {
				str += "EV_S_CRTM_VERSION";
				if (eventData.length == 8) { // Panasonic use String
					str += "[8]=\"" + new String(eventData) + "\"";
				} else if (eventData.length == 5) { // Lenovo
					str += "[5]=\"" + new String(eventData) + "\"";
				} else { // 32 HP use hex
					str += "[" + eventData.length + "]=";
					str += getHexString(eventData) + "";
				}
			} else if (eventType == 0x09) {
				str += "EV_CPU_MICROCODE";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
			} else if (eventType == 0x0a) {
				str += "EV_PLATFORM_CONFIG_FLAGS";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\""; // Panasonic

				// TODO digest is not match. check the spec
				// validateEventdata = true; // Check eventdata & digest later
				_message += " TBD";
			} else if (eventType == 0x0c) {
				// DELL BIOS use 0xc for MBR?
				// EV_COMPACT_HASH
				str += "EV_COMPACT_HASH";

			} else if (eventType == 0x0d) {
				str += "EV_IPL";
				str += "[" + eventData.length + "]";
			} else if (eventType == 0x0e) {
				str += "EV_IPL_PARTITION_DATA";
				str += "[" + eventData.length + "]";
			} else if (eventType == 0x11) {
				str += "EV_NOHOST_INFO";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
				// str += "[" + getHexString(eventData) +"]";
			} else if (eventType == 0x12) {
				str += "EV_SPECIFICATION_IDENTIFIER";
				str += "[" + eventData.length + "]";
				str += "\"" + getHexString(eventData) + "\""; // Panasonic
				// 0000 00 00 01 01 01 02 01 64 00000000000

				validateEventdata = true; // Check eventdata & digest later
			}
			/* Grub */
			else if (eventType == 0x1005) {
				str += "EV_GRUB_BOOT_MSG";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";

				validateEventdata = true; // Check eventdata & digest later
			} else if (eventType == 0x1105) {
				str += "EV_GRUB_KERNEL_CMD";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";

				validateEventdata = true; // Check eventdata & digest later

			} else if (eventType == 0x1205) {
				str += "EV_GRUB_KERNEL";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
			} else if (eventType == 0x1305) {
				str += "EV_GRUB_INITRD";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
			} else if (eventType == 0x1405) {
				str += "EV_GRUB_MODULE";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";
			} else if (eventType == 0x1505) {
				str += "EV_GRUB_MODULE_CMD";
				str += "[" + eventData.length + "]=";
				str += "\"" + new String(eventData) + "\"";

				validateEventdata = true; // Check eventdata & digest later
			} else {
				if (eventData != null)
					str += "unknown[" + eventData.length + "]";
				else
					str += "unknown[null]";
			}
		}
		str += "";

		if ((validateEventdata == true) && (_enableValidation == true)) {
			// if ((validateEventdata)) {
			/* Check Digest */
			byte[] d = DigestTool.SHA1(eventData);
			if (validateDigest(d, digest)) {
				// OK
				_message += " Good eventdata";
				if (log.isDebugEnabled()) {
					log.debug("Valid Evant Data");
					log.debug(" EventData(hex) : "
							+ HexTool.getHexString(eventData));
					log.debug(" Digest(hex)    : "
							+ HexTool.getHexString(digest));
				}
			} else {
				// NG
				if (eventType == 0x04) {
					_message += " BAD eventdata";
					log
							.error("Invalid Evant Data, but ignore type=0x04, workaround of XEN TCGBIOS");
				} else {
					_message += " BAD eventdata";
					_integrity = false;
				}
				if (log.isDebugEnabled()) {
					log.debug("Invalid Evant Data");
					log.debug(" EventData(hex) : "
							+ HexTool.getHexString(eventData));
					log.debug(" Digest(hex)    : "
							+ HexTool.getHexString(digest));
				}
			}
		} else {
			_message += "";
		}

		return str;
	}

	
	private boolean validateDigest(byte[] d1, byte[] d2) {
		if (d1.length != d2.length) {
			return false;
		}
		for (int i = 0; i < d1.length; i++) {
			if (d1[i] != d2[i])
				return false;
		}
		return true;
	}

	// private byte[] getTagEventData(byte[] data) {
	// byte[] buf = new byte[data.length-8];
	// for (int i=0;i<data.length-8;i++) buf[i] = data[i+8];
	// return buf;
	// }

	public String toStringBase64() {
		_printBase64 = true;
		String rc = toString();
		return rc;
	}

	private int getDD(byte[] data, int offset) {
		int i;
		i = data[offset + 3];
		i = i << 4;
		i = data[offset + 2];
		i = i << 4;
		i = data[offset + 1];
		i = i << 4;
		i = data[offset];
		return i;
	}

	private String getBase64String(byte[] digest) {
		if (digest != null) {
			return Base64Tool.encode(digest);
		} else {
			return "N/A";
		}
	}

	/**
	 * @param eventdata
	 */
	public static String getHexString(byte data) {
		int d = data;
		String str = "";
		if (d < 0)
			d += 256;
		if (d < 16)
			str = "0";
		str += Integer.toString(d, 16);
		return str;
	}

	/**
	 * @param eventdata
	 */
	public static String getHexString(byte[] data) {
		if (data == null)
			return "na";
		String str = "";
		for (int i = 0; i < data.length; i++) {
			str += getHexString(data[i]);
		}
		return str;
	}

	// private String getHexString(byte[] data, int offset, int len) {
	// if (data == null) return "na";
	// String str ="";
	// for (int i=offset;i<offset+len;i++) {
	// str += getHexString(data[i]);
	// }
	// return str;
	// }

	/**
	 * @return
	 */
	public String getHexString() {
		return getHexString(digest);
	}

	/**
	 * BIOS Event? String eventdata return just String binary eventdata return
	 * base64(eventdata)
	 * 
	 * @return
	 */
	public String getEventDataStr() {
		String str = "";
		if (eventType == 4) {
			str += new String(eventData);
		} else if ((0x05 & eventType) == 5) {
			str += new String(eventData);
		} else {
			str += Base64Tool.encode(eventData);
		}
		return str;
	}

	/**
	 * IMA?
	 * 
	 * @return
	 */
	public String getEventDataStrForce() {
		String str = "";
		str += new String(eventData);
		return str;
	}

	public void set(int pcrindex, int type, byte[] digest2, byte[] eventdata2) {
		pcrIndex = pcrindex;
		eventType = type;
		digest = digest2;
		eventData = eventdata2;

		if (eventType == 6) {
			pcEventID = UINT32(eventData, 0);
			pcEventData = EventData(eventData, 4);
			pcEventDataSize = pcEventData.length;
		}

	}

	/**
	 * Parse BIOS IML Byte[]
	 * 
	 * @param message
	 * @param ptr
	 * @return
	 */
	public int set(byte[] message, int ptr) {
		pcrIndex = UINT32(message, ptr);
		ptr += 4;
		eventType = UINT32(message, ptr);
		ptr += 4;
		digest = SHA1_DIGEST(message, ptr);
		ptr += 20;
		eventData = EventData(message, ptr);
		ptr += 4 + eventData.length;

		if (eventType == 6) {
			pcEventID = UINT32(eventData, 0);
			pcEventData = EventData(eventData, 4);
			pcEventDataSize = pcEventData.length;
		}

		return ptr;
	}

	/**
	 * @param b
	 * @return
	 */
	public static int UINT32(byte b[], int ptr) {
		int i;

		i = b[ptr + 3] & 0xFF;
		i = i << 8;
		i += b[ptr + 2] & 0xFF;
		i = i << 8;
		i += b[ptr + 1] & 0xFF;
		i = i << 8;
		i += b[ptr] & 0xFF;

		return i;
	}

	/**
	 * @param message
	 * @param ptr
	 * @return
	 */
	private static byte[] SHA1_DIGEST(byte[] message, int ptr) {
		byte b[] = new byte[20];
		int i;
		for (i = 0; i < 20; i++) {
			b[i] = message[ptr + i];
		}
		return b;
	}

	/**
	 * @param message
	 * @param ptr
	 * @return
	 */
	private static byte[] EventData(byte[] message, int ptr) {
		// 
		int len = UINT32(message, ptr);

		byte b[] = new byte[len];
		int i;
		for (i = 0; i < len; i++) {
			b[i] = message[ptr + 4 + i];
		}
		return b;
	}

	public byte[] getDigest() {
		return digest;
	}

	public long getPcrIndex() {
		return pcrIndex;
	}

	public long getEventType() {
		return eventType;
	}

	public byte[] getEventData() {
		return eventData;
	}

	// public byte[] getPCEventData(Event e) {
	public byte[] getPCEventData() {
		return pcEventData;
	}

	public boolean isValid() {
		return _integrity;
	}

	public String getMessage() {
		return _message;
	}

	/**
	 * 
	 * TODO temp
	 * 
	 * @return
	 */
	public String getEventString() {
		return _str;
	}

	public boolean validate() {
		_enableValidation = true;
		_str = this.toString();
		_enableValidation = false;
		return _integrity;
	}

	// public boolean isHold() {
	// return _hold ;
	// }
}
