/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.engine;

import java.util.Enumeration;
import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibm.trl.tcg.pts.integrity.iidb.IIDB;
import com.ibm.trl.tcg.pts.tools.Base64Tool;
import com.ibm.trl.tcg.pts.tools.DigestTool;
import com.ibm.trl.tcg.pts.tools.HexTool;

/**
 * 
 * EventLog by Linux IMA
 * 
 * @author Seiji Munetoh
 * 
 */
public class EventLinuxTCB {
	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());

	/* TCG define three states */
	private static final int VALID = 0;

	private static final int INVALID = 1;

	private static final int UNVERIFIED = 2;

	// private IIDB _iidb;
	private int _imaMeasurmentCount;

	// private boolean _iidbValidationStatus;
	private int _summaryImaValidNum;

	// private boolean _verbose;
	private int _summaryImaInvalidNum;

	private int _summaryImaUnverifiedNum;

	// public String remediation;

	public String message;

	private int _imaInvalidMeasurmentCount;

	Hashtable<String, String> resultArray;

	// private int _countInvalidEvent;

	// private int _countUnverifiedEvent;

	public EventLinuxTCB() {
		_imaMeasurmentCount = 0;
		_imaInvalidMeasurmentCount = 0;
		_summaryImaValidNum = 0;
		_summaryImaInvalidNum = 0;
		_summaryImaUnverifiedNum = 0;
		resultArray = new Hashtable<String, String>();
	}

	/**
	 * 
	 * Validate Linux-IMA Boot Aggrigate
	 * 
	 * 2007-11-09 Munetoh implement... :-)
	 * 
	 * @param _properties
	 * @param stateName
	 * @param event
	 * @throws Exception
	 */
	public boolean checkImaAggrigate(PlatformProperties _properties,
			String stateName, Event event) throws Exception {
		// IMA Aggrigate
		// http://lwn.net/Articles/139878/ OLD
		// SHA1(PCR[0]...PCR[7])
		boolean rc = true;

		byte[] buf = new byte[8 * 20];
		for (int i = 0; i < 8; i++) {
			PlatformProperty p = _properties.getPropertyByName("tpm.pcr." + i);
			String base64 = p.getValue();
			byte[] b = Base64Tool.decode(base64);

			if (b.length != 20) {
				log.error("Wrong digest" + b.length + " base64 " + base64);
			} else {
				for (int j = 0; j < 20; j++) {
					buf[20 * i + j] = b[j];
				}
			}
		}

		byte[] digest = DigestTool.SHA1(buf);
		byte[] given = event.getDigest();

		/* compare */
		for (int i = 0; i < 20; i++) {
			if (digest[i] != given[i]) {

				// throw new Exception("IMA Aggrigate validation was Failed ");
				rc = false;
			}
		}
		if (rc == false) {
			log
					.warn("IMA Aggrigate validation was Failed - TODO Use PCR in IR");
			log.warn("buf " + HexTool.getHexString(buf));
			log.warn("digest " + HexTool.getHexString(digest));
			log.warn("digest " + HexTool.getHexString(event.getDigest()));
		}
		return rc;
	}

	/**
	 * 
	 * Validate IMA Measurement
	 * 
	 * 2007-11-10 Munetoh reduce same remediation... one reason string for all
	 * IMA measurement
	 * 
	 * @param prop
	 * @param stateName
	 * @param event
	 * @param iidb
	 * @return
	 * @throws Exception
	 */
	public String validateImaMeasurement(PlatformProperties prop,
			String stateName, Event event, IIDB iidb) throws Exception {

		if (log.isDebugEnabled()) {
			log.debug("setIMAProperty start");
			// log.debug("setIMAProperty IIDB " + _iidb.toString());
		}

		String pname = "os.measure." + _imaInvalidMeasurmentCount;
		String name = new String(event.getEventData());
		String digest = Base64Tool.encode(event.getDigest());

		// boolean rc;
		String remediation = "";

		/* Digest is not in this Manifest, need to ask IIDB */
		message = "";
		if (iidb != null) {
			/* Issue Query */
			int result = iidb.queryByDigest(event.getDigest());

			if (result == INVALID) { // 1 INVALID
				// TODO rc = false;
				log.error("IIDB result : " + result);
				// log.error("guardString : " + guardString);
				log.error("digest      : "
						+ Base64Tool.encode(event.getDigest()));
				// log.error(event.toString());
				remediation = iidb.getRemediation();
				message += " INVALID " + remediation;
				_summaryImaInvalidNum++;
				// rc = false;
				prop.setProperty(pname + ".name", name);
				prop.setProperty(pname + ".digest", digest);
				prop.setProperty(pname + ".integrity", "invalid");
				prop.setProperty(pname + ".remediation", remediation);

				resultArray.put(remediation, remediation);

				if (log.isDebugEnabled()) {
					log.debug("remediation : " + remediation);
				}

				_imaInvalidMeasurmentCount++;
			} else if (result == VALID) { // 0 VALID
				if (log.isTraceEnabled()) {
					log.trace("VALID by IIDB");
				}
				/* OK no problem */
				message += " VALID";
			} else if (result == UNVERIFIED) { // 2 UNVERIFIED
				// if (log.isTraceEnabled()) {
				log.warn("UNVERIFIED by IIDB (Check IIDB)");
				// }
				/* Digest value is missing in IIDB */
				message += " UNVERIFIED";
				_summaryImaUnverifiedNum++;
				prop.setProperty(pname + ".name", name);
				prop.setProperty(pname + ".digest", digest);
				prop.setProperty(pname + ".integrity", "unverified");
				// prop.setProperty(pname + ".remediation", remediation);
				_imaInvalidMeasurmentCount++;
			} else {
				log.error("Internal error? wrong query state result = "
						+ result);
				// Must be a BUG
				message += " ERROR";
				// rc = false;
			}

			// log.error("ask - FALSE DEBUG digest : " + value
			// + " != " + Base64Tool.encode(event.getDigest()));
			// _message += " unverified";
		} // ask
		else {
			if (log.isDebugEnabled()) {
				// log.debug("not verifyed " + guardString + " with IIDB
				// (digest=" + Base64Tool.encode(event.getDigest()) + ")");
				log.debug("not verifyed with IIDB (digest="
						+ Base64Tool.encode(event.getDigest()) + ")");
			}
			message += " unverified";
			prop.setProperty(pname + ".name", name);
			prop.setProperty(pname + ".digest", digest);
			prop.setProperty(pname + ".integrity", "unverified");
			// prop.setProperty(pname + ".remediation", remediation);
			_imaInvalidMeasurmentCount++;
		}

		// if (_iidb != null) {
		// // TODO Add validation by IIDB
		// } else {
		// log.debug("checkDigestByIIDB iidb == null, "
		// + remediation);
		// //_iidbValidationStatus = false;
		// prop.setProperty(name, digest);
		// _summaryImaUnverifiedNum++;
		// }

		_imaMeasurmentCount++;
		// _iidbValidationStatus = true;
		return name;
	}

	public String addSummary(PlatformProperties prop) throws Exception {
		String remediation = "";
		int count = 0;
		// TODO
		Enumeration e = resultArray.elements();
		while (e.hasMoreElements()) {
			String str = e.nextElement().toString();
			remediation += str + ",";
			count++;

			// System.out.println(str);

		}
		if (count > 0) {
			remediation += count + " vulnelable packages are found,";
		} else {
			remediation += "";
		}

		prop.setProperty("ima.summary.total", "" + _imaMeasurmentCount);
		prop.setProperty("ima.summary.valid", "" + _summaryImaValidNum);
		prop.setProperty("ima.summary.invalid", "" + _summaryImaInvalidNum);
		prop.setProperty("ima.summary.unverified", ""
				+ _summaryImaUnverifiedNum);

		return remediation;
	}

	/**
	 * 
	 * See linuxtcb.statesiagram
	 * 
	 * this function generate following assertions linux.kernel.lsm :
	 * exist/notextst linux.kernel.lsm.ima: enabled/disabled/unknown
	 * linux.kernel.lsm.selinux: enabled/disabled/unknown
	 * linux.kernel.lsm.apparmor: enabled/disabled/unknown
	 * 
	 * 
	 * @param _properties
	 * @param string
	 * @throws Exception
	 */
	public void setKernelCommandline(PlatformProperties prop, String cmdlineProp)
			throws Exception {
		String cmdline = prop.getPropertyByName(cmdlineProp).getValue();
		String[] cla = cmdline.split(" ");
		int ima = -1;
		int selinux = -1;

		/* set defaults */
		prop.setProperty("linux.kernel.lsm", "unknown");
		prop.setProperty("linux.kernel.lsm.ima", "unknown");
		prop.setProperty("linux.kernel.lsm.selinux", "unknown");
		prop.setProperty("linux.kernel.lsm.apparmor", "unknown");

		for (int i = 0; i < cla.length; i++) {
			log.debug("" + cla[i]);
			if (cla[i].equals("ima=1"))
				ima = 1;
			if (cla[i].equals("ima=0"))
				ima = 0;
			if (cla[i].equals("selinux=1"))
				selinux = 1;
			if (cla[i].equals("selinux=0"))
				selinux = 0;
		}

		if (ima == 1) {
			prop.setProperty("linux.kernel.lsm", "exist");
			prop.setProperty("linux.kernel.lsm.ima", "enabled");
		} else if (ima == 0) {
			prop.setProperty("linux.kernel.lsm", "exist");
			prop.setProperty("linux.kernel.lsm.ima", "disabled");
		} else if (selinux == 1) {
			prop.setProperty("linux.kernel.lsm", "exist");
			prop.setProperty("linux.kernel.lsm.selinux", "enabled");
		} else if (selinux == 0) {
			prop.setProperty("linux.kernel.lsm", "exist");
			prop.setProperty("linux.kernel.lsm.selinux", "disabled");
		} else {
			prop.setProperty("linux.kernel.lsm", "unknown");
		}

	}

}
