/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.engine;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibm.trl.tcg.pts.tools.Base64Tool;

/**
 * @author Seiji Munetoh
 * 
 */
public class PlatformProperties {

	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());

	// private Property[] _p;
	private Vector _p;

	private boolean _integrity;

	// private boolean _verbose;

	// private int dbIndex;

	public PlatformProperties() {
		// this.dbIndex = dbIndex;
		_p = new Vector();
	}

	/**
	 * Initialize TVE Properties
	 * 
	 */
	public void init() {
		_p = new Vector();
		int i;
		/* Reset PCR */
		byte[] pcr = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00 };
		byte[] pcr2 = { (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
				(byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
				(byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
				(byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
				(byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, };

		String b64zero = Base64Tool.encode(pcr);
		String b64ff = Base64Tool.encode(pcr2);
		for (i = 0; i < 16; i++) {
			this.setValidProperty("tpm.pcr." + i, b64zero);
		}
		for (i = 16; i < 24; i++) {
			this.setValidProperty("tpm.pcr." + i, b64ff);
		}
	}

	/**
	 * @param _p
	 */
	public void init(PlatformProperty[] p) {
		_p = new Vector();
		for (int i = 0; i < p.length; i++) {
			// TODO
			if (p[i].getName().equals("integrity")) {
				if (p[i].isValid())
					_integrity = true;
				else
					_integrity = false;
			}
			// 2007-11-03 Munetoh use Logger
			// if (p[i].getName().equals("verbose")) {
			// if (p[i].isValid())
			// _verbose = true;
			// else
			// _verbose = false;
			// }

			if (log.isDebugEnabled()) {
				String str = "Property[" + i + "]:" + p[i].getName() + " = "
						+ p[i].getValue();
				if (p[i].isValid())
					log.debug(str + " << VALID");
				else
					log.debug(str + " << INVALID or UNKNOWN");
			}

			_p.add(p[i]);
		}
	}

	/**
	 * 
	 */
	public void printProperties() {
		for (int i = 0; i < _p.size(); i++) {
			PlatformProperty p = (PlatformProperty) _p.get(i);
			System.out.println(i + " " + p.getName() + " = " + p.getValue());
		}

	}

	/**
	 * @return
	 */
	public PlatformProperty[] get() {
		PlatformProperty pa[] = new PlatformProperty[_p.size()];
		for (int i = 0; i < _p.size(); i++) {
			pa[i] = (PlatformProperty) _p.get(i);
		}
		return pa;
	}

	/**
	 * @param p
	 */
	public void add(PlatformProperty p) {
		_p.add(p);
	}

	/**
	 * get PlatformProperty by name
	 * 
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public PlatformProperty getPropertyByName(String name) throws Exception {
		for (int i = 0; i < _p.size(); i++) {
			PlatformProperty p = (PlatformProperty) _p.get(i);
			if (p.equals(name)) {
				return p;
			}
		}
		log.error("Property not found. name = " + name);
		// throw new Exception("Property not found. name = " + name);
		return null;
	}

	/**
	 * get PlatformProperty value by PlatformProperty name
	 * 
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public String getPropertyValueByName(String name) throws Exception {
		PlatformProperty p = this.getPropertyByName(name);
		if (p != null) {
			return p.getValue();
		} else {
			return null;
		}
	}

	/**
	 * @param name
	 * @param value
	 * @return
	 * @throws Exception
	 */
	public boolean verifyProperty(String name, String value) throws Exception {
		// TODO use hash table
		for (int i = 0; i < _p.size(); i++) {
			PlatformProperty p = (PlatformProperty) _p.get(i);
			if ((p.equals(name))) {
				String v = p.getValue();
				if (v.equals(value)) {
					if (log.isDebugEnabled())
						log.debug("verifyProperty() => HIT");
					p.setValid();
					return true;
				} else {
					log.warn("verifyProperty(" + name + "," + value
							+ "), expected value = " + p.getValue());
				}
			}
		}
		log.error("verifyProperty(" + name + "," + value + ") failed");
		_integrity = false;
		throw new Exception("verifyProperty(" + name + "," + value + ") failed");
		// return false;
	}

	/**
	 * 
	 * @param name
	 * @param value
	 * @throws Exception
	 */
	public void setProperty(String name, String value) {
		if (checkPropertyByName(name)) {
			// log.error("set Property confrict. name = " + name);
			// throw new Exception("set Property confrict. name = " + name);
			update(name, value);
		} else {
			PlatformProperty p = new PlatformProperty(name, value);
			_p.add(p);
		}
	}

	/**
	 * @param name
	 * @return
	 */
	private boolean checkPropertyByName(String name) {
		for (int i = 0; i < _p.size(); i++) {
			PlatformProperty p = (PlatformProperty) _p.get(i);
			if (p.equals(name)) {
				return true; // HIT
			}
		}
		return false;
	}

	/**
	 * @param string
	 * @param string2
	 */
	public void setValidProperty(String name, String value) {
		PlatformProperty p = new PlatformProperty(name, value);
		p.setValid();
		_p.add(p);

	}

	/**
	 * @return
	 */
	public int size() {
		return _p.size();
	}

	/**
	 * @param string
	 * @param string2
	 */
	public void update(String name, String value) {
		for (int i = 0; i < _p.size(); i++) {
			PlatformProperty p = (PlatformProperty) _p.get(i);
			if ((p.equals(name))) {

				if (log.isTraceEnabled()) {
					log.trace("update");
					log.trace(" " + name);
					log.trace(" " + p.getValue());
					log.trace(" " + value);
				}
				p.changeValue(value);
				return; // TODO just update the 1st hit
			}
		}
	}

	/**
	 * @param resultFilename
	 */
	public void saveProperties(String resultFilename) {
		if (resultFilename == null) {
			log.error("resultFilename is null");
			return;
		}

		try {
			FileOutputStream fos = new FileOutputStream(resultFilename);
			OutputStreamWriter osw = new OutputStreamWriter(fos, "MS932");
			BufferedWriter bw = new BufferedWriter(osw);

			for (int i = 0; i < _p.size(); i++) {
				PlatformProperty p = (PlatformProperty) _p.get(i);
				bw.write(i + " " + p.getName() + " = " + p.getValue() + "\n");
			}

			bw.close();
			osw.close();
			fos.close();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/**
	 * Save prop to log (debug)
	 * 
	 */
	public void log() {
		if (log.isDebugEnabled()) {
			for (int i = 0; i < _p.size(); i++) {
				PlatformProperty p = (PlatformProperty) _p.get(i);
				log.debug("Property) " + i + " " + p.getName() + " = "
						+ p.getValue());
			}

		}
	}

}
