/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.eventlog;

import java.util.Vector;

import com.ibm.trl.tcg.pts.engine.Event;

/**
 * Just store the events for each PCR
 * 
 * @author Seiji Munetoh
 * 
 */
public class EventSet {

	public int pcrIndex;

	private Vector<Event> _ev;

	public int size;

	private String _name = null;

	public EventSet() {
		_name = "na"; // TODO
		_ev = new Vector<Event>();
		size = 0;
	}

	public EventSet(String name) {
		_name = name;
		_ev = new Vector<Event>();
		size = 0;
	}

	public void setPcrIndex(int pcrindex) {
		pcrIndex = pcrindex;
	}

	public void addEvent(int type, byte[] digest, byte[] eventdata) {
		Event e = new Event();
		e.set(pcrIndex, type, digest, eventdata);
		_ev.add(e);
		size++;
	}

	public Event[] getEventList() {
		Event[] elist = new Event[_ev.size()];

		for (int i = 0; i < _ev.size(); i++) {
			elist[i] = (Event) _ev.get(i);
		}
		return elist;
	}

	public Event getEvent(int index) {
		if (index > size)
			return null;
		return (Event) _ev.get(index);
	}

	public String getName() {
		return _name;
	}

	/**
	 * 
	 * Replace Events
	 * 
	 * @param event
	 */
	public void setEventList(Event[] event) {
		_ev = null;
		_ev = new Vector<Event>();
		size = event.length;

		for (int i = 0; i < size; i++) {
			_ev.add(event[i]);
		}
	}

}
