/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.vulnerability.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

/**
 * Get file from Internet.
 * @author Megumi Nakamura
 */
public class GetFileFromInternet {

	private static final int BYTE_LEN = 1024;

	/**
	 * Main method to start the test.
	 * 
	 * @param args
	 *            arguments
	 */
	public static void main(String[] args) {
		new GetFileFromInternet().getFile("http://people.redhat.com/mjc/oval/"
				+ "com.redhat.rhsa-all.xml", "C:///temp", true);
	}

	/**
	 * Get the file.
	 * 
	 * @param uri
	 *            The URL of the location for the file
	 * @param dir
	 *            A directory to store the file
	 * @param overwrite
	 *            true overwrite existing file
	 * @return The name of a new location of the downloaded file.
	 */
	public String getFile(String uri, String dir, boolean overwrite) {

		URLConnection con = null;
		String fileName = null;
		String newFileName = null;
		File file = null;
		try {
			URL url = new URL(uri);

			fileName = url.getPath();
			int i = fileName.lastIndexOf('/');
			if (i != -1) {
				fileName = fileName.substring(i + 1);
			}

			if (dir == null) {
				newFileName = fileName;
			} else if (dir.equalsIgnoreCase("")) {
				newFileName = fileName;
			} else {
				File dirFile = new File(dir);
				if (!(dirFile.exists())) {
					if (!dirFile.mkdirs()) {
						throw new FileNotFoundException();
					}
				}
				newFileName = dir + File.separator + fileName;
			}
			file = new File(newFileName);

			if (!file.exists() || overwrite) {
				con = url.openConnection();

				BufferedInputStream bufInStream = new BufferedInputStream(con
						.getInputStream());
				BufferedOutputStream bufOutStream = new BufferedOutputStream(
						new FileOutputStream(file));
				byte[] byteRead = new byte[BYTE_LEN];
				int nlen = 0;
				while (true) {
					int rlen = bufInStream.read(byteRead);
					if (rlen == -1) {
						break;
					}
					bufOutStream.write(byteRead, 0, rlen);
					nlen += rlen;
				}
				bufOutStream.flush();
				if (con.getLastModified() > 0) {
					if (file.setLastModified(con.getLastModified())) {

					}
				}
				bufOutStream.close();
				bufInStream.close();
			}

		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

		return newFileName;
	}
}
