/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.vulnerability.tool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

/**
 * Make TM3 file for visualization of the vulnerabiltiy map.
 * 
 * @author Megumi Nakamura
 */
public class MakeTM3File {

	private FileWriter fileWriter = null;

	private BufferedWriter bufWriter = null;

	// data
	private int integrity;

	private String cvss;

	private String loc;

	private String layer;

	private long build;

	private String requiredNum;

	private String requiredPkgs;

	/**
	 * Constructor.
	 * 
	 * @param outputFile
	 *            The name of output file
	 * @throws Exception
	 *             All exceptions
	 */
	public MakeTM3File(String outputFile) throws Exception {
		writeFileOpen(outputFile, null);
		initializeVariable();
	}

	/**
	 * Constructor.
	 * 
	 * @param outputFile
	 *            The name of output file
	 * @param outputDir
	 *            The name of output directory
	 * @throws Exception
	 *             All exceptions
	 */
	public MakeTM3File(String outputFile, String outputDir) throws Exception {
		writeFileOpen(outputFile, outputDir);
		initializeVariable();
	}

	/**
	 * Default value.
	 */
	private void initializeVariable() {
		setCvss("0");
		setIntegrity(2);
		setLayer(null);
		setLoc("0");
		setBuild(0);
		setRequiredNum("0");
		setRequiredPkgs(null);
	}

	/**
	 * Write.
	 * 
	 * @param integrity
	 * @param cvss
	 * @param loc
	 * @param layer
	 */
	public void writeVariable() {
		if (layer != null && cvss != null) {
			writeFileLine(integrity + "\t" + cvss + "\t" + loc + "\t"
					+ requiredNum + "\t" + build + "\t" + layer);
		} else if (layer != null) {
			writeFileLine(integrity + "\t0\t" + loc + "\t" + requiredNum + "\t"
					+ build + "\t" + layer);
		} else if (cvss != null) {
			writeFileLine(integrity + "\t" + cvss + "\t" + loc + "\t"
					+ requiredNum + "\t" + build + "\t");
		}
		initializeVariable();
	}

	/**
	 * Setup the file to write.
	 * 
	 * @param outputFile
	 *            The file for output
	 * @param outputDir
	 *            The directory for outputFile
	 * @throws Exception
	 *             All exceptions
	 */
	private void writeFileOpen(String outputFile, String outputDir)
			throws Exception {
		if (outputDir != null) {
			writeFileOpen(outputDir + File.separator + outputFile);
		} else {
			writeFileOpen(outputFile);
		}
	}

	/**
	 * Setup the file to write.
	 * 
	 * @param outputFile
	 *            which contains the result
	 * @throws Exception
	 *             All exceptions
	 */
	private void writeFileOpen(String outputFile) throws Exception {
		try {
			fileWriter = new FileWriter(outputFile);
			bufWriter = new BufferedWriter(fileWriter);

			writeFileLine("Integrity\tCVSS\tLOC\tDependency\tBuild\t");
			writeFileLine("INTEGER\tFLOAT\tINTEGER\tINTEGER\tSTRING\t");

		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Close the file.
	 */
	public void writeFileClose() {
		try {
			bufWriter.flush();
			bufWriter.close();
			fileWriter.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Write a line.
	 * 
	 * @param line
	 *            written in a file
	 */
	private void writeFileLine(String line) {
		try {
			bufWriter.write(line);
			bufWriter.newLine();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Setter and Getter.
	 */
	public String getCvss() {
		return cvss;
	}

	public void setCvss(String cvss) {
		this.cvss = cvss;
	}

	public int getIntegrity() {
		return integrity;
	}

	public void setIntegrity(int integrity) {
		this.integrity = integrity;
	}

	public String getLayer() {
		return layer;
	}

	public void setLayer(String layer) {
		this.layer = layer;
	}

	public String getLoc() {
		return loc;
	}

	public void setLoc(String loc) {
		this.loc = loc;
	}

	public long getBuild() {
		return build;
	}

	public void setBuild(long build) {
		this.build = build;
	}

	public String getRequiredNum() {
		return requiredNum;
	}

	public void setRequiredNum(String requiredNum) {
		// because 0 causes error
		int req = Integer.valueOf(requiredNum);
		req = req + 1;
		this.requiredNum = Integer.toString(req);
	}

	public String getRequiredPkgs() {
		return requiredPkgs;
	}

	public void setRequiredPkgs(String requiredPkgs) {
		this.requiredPkgs = requiredPkgs;
	}

}
