/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */

package com.ibm.trl.tcg.pts.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibm.trl.tcg.pts.tools.Base64Tool;

/**
 * 
 * Set properties for Grub-IMA measurements
 * 
 * @author Seiji Munetoh
 * 
 */
public class EventGrub {

	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());

	/**
	 * 
	 * @deprecated use setAssertion() as for general use
	 * 
	 * @param prop
	 * @param stateName
	 * @param e
	 * @return
	 * @throws Exception
	 */
	public boolean setGrubProperty(PlatformProperties prop, String stateName,
			Event e) throws Exception {
		if (stateName.equals("FinalAction")) {
			prop.setProperty("GrubFinalAction", new String(e.getEventData()));
			return true;
		} else if (stateName.equals("Initrd")
				|| stateName.equals("XenModuleInitrd")) {
			prop.setProperty("linux.initrd.digest", Base64Tool.encode(e
					.getDigest()));
			return true;
		} else if (stateName.equals("Kernel")
				|| stateName.equals("XenModuleKernel")) {
			prop.setProperty("linux.kernel.digest", Base64Tool.encode(e
					.getDigest()));
			return true;
		} else if (stateName.equals("KernelCmd")
				|| stateName.equals("CommandKernel")) {
			String cl = new String(e.getEventData());
			String[] cla = cl.split(" ");
			boolean ima = false;
			boolean selinux = false;

			for (int i = 0; i < cla.length; i++) {
				log.debug("" + cla[i]);
				if (cla[i].equals("ima=1"))
					ima = true;
				if (cla[i].equals("ima=0"))
					ima = false;
				if (cla[i].equals("selinux=1"))
					selinux = true;
				if (cla[i].equals("selinux=0"))
					selinux = false;
			}

			if (ima) {
				prop.setProperty("os.kernel.opt.ima", "valid");
			}
			if (selinux) {
				prop.setProperty("os.kernel.opt.selinux", "valid");
			}
			return true;
		} else if (stateName.equals("XenKernel")) {
			prop.setProperty("os.xen.digest", Base64Tool.encode(e.getDigest()));
			prop.setProperty("vmm", "exist");
			return true;
		} else if (stateName.equals("CommandInitrd")) {
			log.warn("No property for setGrubProperty state " + stateName
					+ ", unknown event " + e.toString());
			return true;
		} else if (stateName.equals("XenKernelCmd")) {
			log.warn("No property for setGrubProperty state " + stateName
					+ ", unknown event " + e.toString());
			return true;
		} else {
			log.error("setGrubProperty state " + stateName + ", unknown event "
					+ e.toString());
		}

		return false;
	}

}
