package com.ibm.trl.tcg.pts.eventlog;

import java.io.BufferedReader;
import java.io.FileReader;

import com.ibm.trl.tcg.pts.tools.HexTool;

public class PCRS {

	private byte[][] pcrs;
	private int pcrNum;

	public void loadfile(String pcrsFilename) throws Exception {
		pcrs = new byte[24][20];
		FileReader in = new FileReader(pcrsFilename);
		BufferedReader br = new BufferedReader(in);
		String line;
		int pcrIndex = 0;
		while ((line = br.readLine()) != null) {
			// System.out.println(line);
			String[] sp = line.split(" ");
			for (int i = 0; i < 20; i++) {
				int si = HexTool.getByte(sp[1 + i]);
				pcrs[pcrIndex][i] = (byte) si;
			}
			pcrIndex++;
		}
		br.close();
		in.close();

		pcrNum = pcrIndex;
	}

	public byte[][] getByteArray() {
		byte [][] out = new byte[pcrNum][20];
		for (int i=0;i<pcrNum;i++) {
			System.arraycopy(pcrs[i], 0, out[i], 0, 20);
		}
		return out;
	}

	public int size() {
		return pcrNum;
	}

}
