/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */

package com.ibm.trl.tcg.pts.tools;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * Logger Tool
 * 
 * OpenPlatformTrustService uses Commons-Logging
 * 
 * http://commons.apache.org/logging/
 * http://commons.apache.org/downloads/download_logging.cgi
 * 
 * Quick Guide (Japanese)
 * http://www.atmarkit.co.jp/fjava/rensai2/jakarta09/jakarta09.html
 * http://www.h7.dion.ne.jp/~s_wat/jakarta/logging.html
 * 
 * @author Seiji Munetoh
 * 
 */
public class LoggerTool {
	Log log = LogFactory.getLog(this.getClass());

	public void generateSampleLog() {
		log.fatal("test");
		log.error("test");
		log.warn("test");
		log.info("test");
		log.debug("test");
		log.trace("test");
	}

	public void printStatus() {
		if (log.isFatalEnabled()) {
			System.out.println("Fatal  : Enabled");
		} else {
			System.out.println("Fatal  : Disbled");
		}

		if (log.isErrorEnabled()) {
			System.out.println("Error  : Enabled");
		} else {
			System.out.println("Error  : Disbled");
		}
		if (log.isWarnEnabled()) {
			System.out.println("Warn   : Enabled");
		} else {
			System.out.println("Warn   : Disbled");
		}
		if (log.isInfoEnabled()) {
			System.out.println("Info   : Enabled");
		} else {
			System.out.println("Info   : Disbled");
		}
		if (log.isDebugEnabled()) {
			System.out.println("Debug  : Enabled");
		} else {
			System.out.println("Debug  : Disbled");
		}
		if (log.isTraceEnabled()) {
			System.out.println("Trace  : Enabled");
		} else {
			System.out.println("Trace  : Disbled");
		}

	}

}
